/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.core.BinaryFieldMapper;
import org.elasticsearch.index.mapper.core.BooleanFieldMapper;
import org.elasticsearch.index.mapper.core.ByteFieldMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.DoubleFieldMapper;
import org.elasticsearch.index.mapper.core.FloatFieldMapper;
import org.elasticsearch.index.mapper.core.IntegerFieldMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.ShortFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.mapper.internal.AnalyzerMapper;
import org.elasticsearch.index.mapper.internal.BoostFieldMapper;
import org.elasticsearch.index.mapper.internal.IdFieldMapper;
import org.elasticsearch.index.mapper.internal.IndexFieldMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.mapper.internal.RoutingFieldMapper;
import org.elasticsearch.index.mapper.internal.SizeFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.mapper.internal.TypeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.index.mapper.multifield.MultiFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class DocumentMapperParser
extends AbstractIndexComponent {
    final AnalysisService analysisService;
    private final RootObjectMapper.TypeParser rootObjectTypeParser = new RootObjectMapper.TypeParser();
    private final Object typeParsersMutex = new Object();
    private volatile ImmutableMap<String, Mapper.TypeParser> typeParsers;

    public DocumentMapperParser(Index index, AnalysisService analysisService) {
        this(index, ImmutableSettings.Builder.EMPTY_SETTINGS, analysisService);
    }

    public DocumentMapperParser(Index index, @IndexSettings Settings indexSettings, AnalysisService analysisService) {
        super(index, indexSettings);
        this.analysisService = analysisService;
        this.typeParsers = new MapBuilder<String, ByteFieldMapper.TypeParser>().put("byte", new ByteFieldMapper.TypeParser()).put("short", (ByteFieldMapper.TypeParser)((Object)new ShortFieldMapper.TypeParser())).put("integer", (ByteFieldMapper.TypeParser)((Object)new IntegerFieldMapper.TypeParser())).put("long", (ByteFieldMapper.TypeParser)((Object)new LongFieldMapper.TypeParser())).put("float", (ByteFieldMapper.TypeParser)((Object)new FloatFieldMapper.TypeParser())).put("double", (ByteFieldMapper.TypeParser)((Object)new DoubleFieldMapper.TypeParser())).put("boolean", (ByteFieldMapper.TypeParser)((Object)new BooleanFieldMapper.TypeParser())).put("binary", (ByteFieldMapper.TypeParser)((Object)new BinaryFieldMapper.TypeParser())).put("date", (ByteFieldMapper.TypeParser)((Object)new DateFieldMapper.TypeParser())).put("ip", (ByteFieldMapper.TypeParser)((Object)new IpFieldMapper.TypeParser())).put("string", (ByteFieldMapper.TypeParser)((Object)new StringFieldMapper.TypeParser())).put("object", (ByteFieldMapper.TypeParser)((Object)new ObjectMapper.TypeParser())).put("nested", (ByteFieldMapper.TypeParser)((Object)new ObjectMapper.TypeParser())).put("multi_field", (ByteFieldMapper.TypeParser)((Object)new MultiFieldMapper.TypeParser())).put("geo_point", (ByteFieldMapper.TypeParser)((Object)new GeoPointFieldMapper.TypeParser())).immutableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putTypeParser(String type, Mapper.TypeParser typeParser) {
        Object object = this.typeParsersMutex;
        synchronized (object) {
            this.typeParsers = new MapBuilder<String, Mapper.TypeParser>().putAll(this.typeParsers).put(type, typeParser).immutableMap();
        }
    }

    public Mapper.TypeParser.ParserContext parserContext() {
        return new Mapper.TypeParser.ParserContext(this.analysisService, this.typeParsers);
    }

    public DocumentMapper parse(String source) throws MapperParsingException {
        return this.parse(null, source);
    }

    public DocumentMapper parse(@Nullable String type, String source) throws MapperParsingException {
        return this.parse(type, source, null);
    }

    public DocumentMapper parse(@Nullable String type, String source, String defaultSource) throws MapperParsingException {
        Tuple<String, Map<String, Object>> t;
        HashMap<String, Object> mapping = null;
        if (source != null) {
            t = this.extractMapping(type, source);
            type = t.v1();
            mapping = t.v2();
        }
        if (mapping == null) {
            mapping = Maps.newHashMap();
        }
        if (type == null) {
            throw new MapperParsingException("Failed to derive type");
        }
        if (defaultSource != null && (t = this.extractMapping("_default_", defaultSource)).v2() != null) {
            XContentHelper.mergeDefaults(mapping, t.v2());
        }
        Mapper.TypeParser.ParserContext parserContext = new Mapper.TypeParser.ParserContext(this.analysisService, this.typeParsers);
        DocumentMapper.Builder docBuilder = MapperBuilders.doc(this.index.name(), this.indexSettings, (RootObjectMapper.Builder)this.rootObjectTypeParser.parse(type, mapping, parserContext));
        for (Map.Entry entry : mapping.entrySet()) {
            String fieldName = Strings.toUnderscoreCase((String)entry.getKey());
            Object fieldNode = entry.getValue();
            if ("_source".equals(fieldName) || "sourceField".equals(fieldName)) {
                docBuilder.sourceField(this.parseSourceField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_size".equals(fieldName)) {
                docBuilder.sizeField(this.parseSizeField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_id".equals(fieldName) || "idField".equals(fieldName)) {
                docBuilder.idField(this.parseIdField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_index".equals(fieldName) || "indexField".equals(fieldName)) {
                docBuilder.indexField(this.parseIndexField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_type".equals(fieldName) || "typeField".equals(fieldName)) {
                docBuilder.typeField(this.parseTypeField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_uid".equals(fieldName) || "uidField".equals(fieldName)) {
                docBuilder.uidField(this.parseUidField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_routing".equals(fieldName)) {
                docBuilder.routingField(this.parseRoutingField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_parent".equals(fieldName)) {
                docBuilder.parentFiled(this.parseParentField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_boost".equals(fieldName) || "boostField".equals(fieldName)) {
                docBuilder.boostField(this.parseBoostField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_all".equals(fieldName) || "allField".equals(fieldName)) {
                docBuilder.allField(this.parseAllField((Map)fieldNode, parserContext));
                continue;
            }
            if ("_analyzer".equals(fieldName)) {
                docBuilder.analyzerField(this.parseAnalyzerField((Map)fieldNode, parserContext));
                continue;
            }
            if ("index_analyzer".equals(fieldName)) {
                docBuilder.indexAnalyzer(this.analysisService.analyzer(fieldNode.toString()));
                continue;
            }
            if ("search_analyzer".equals(fieldName)) {
                docBuilder.searchAnalyzer(this.analysisService.analyzer(fieldNode.toString()));
                continue;
            }
            if (!"analyzer".equals(fieldName)) continue;
            docBuilder.indexAnalyzer(this.analysisService.analyzer(fieldNode.toString()));
            docBuilder.searchAnalyzer(this.analysisService.analyzer(fieldNode.toString()));
        }
        if (!docBuilder.hasIndexAnalyzer()) {
            docBuilder.indexAnalyzer(this.analysisService.defaultIndexAnalyzer());
        }
        if (!docBuilder.hasSearchAnalyzer()) {
            docBuilder.searchAnalyzer(this.analysisService.defaultSearchAnalyzer());
        }
        ImmutableMap<String, Object> attributes = ImmutableMap.of();
        if (mapping.containsKey("_meta")) {
            attributes = ImmutableMap.copyOf((Map)mapping.get("_meta"));
        }
        docBuilder.meta(attributes);
        DocumentMapper documentMapper = docBuilder.build(this);
        documentMapper.refreshSource();
        return documentMapper;
    }

    private UidFieldMapper.Builder parseUidField(Map<String, Object> uidNode, Mapper.TypeParser.ParserContext parserContext) {
        UidFieldMapper.Builder builder = MapperBuilders.uid();
        return builder;
    }

    private BoostFieldMapper.Builder parseBoostField(Map<String, Object> boostNode, Mapper.TypeParser.ParserContext parserContext) {
        String name = boostNode.get("name") == null ? "_boost" : boostNode.get("name").toString();
        BoostFieldMapper.Builder builder = MapperBuilders.boost(name);
        TypeParsers.parseNumberField(builder, name, boostNode, parserContext);
        for (Map.Entry<String, Object> entry : boostNode.entrySet()) {
            String propName = Strings.toUnderscoreCase(entry.getKey());
            Object propNode = entry.getValue();
            if (!propName.equals("null_value")) continue;
            builder.nullValue(XContentMapValues.nodeFloatValue(propNode));
        }
        return builder;
    }

    private TypeFieldMapper.Builder parseTypeField(Map<String, Object> typeNode, Mapper.TypeParser.ParserContext parserContext) {
        TypeFieldMapper.Builder builder = MapperBuilders.type();
        TypeParsers.parseField(builder, builder.name, typeNode, parserContext);
        return builder;
    }

    private IdFieldMapper.Builder parseIdField(Map<String, Object> idNode, Mapper.TypeParser.ParserContext parserContext) {
        IdFieldMapper.Builder builder = MapperBuilders.id();
        TypeParsers.parseField(builder, builder.name, idNode, parserContext);
        return builder;
    }

    private RoutingFieldMapper.Builder parseRoutingField(Map<String, Object> routingNode, Mapper.TypeParser.ParserContext parserContext) {
        RoutingFieldMapper.Builder builder = MapperBuilders.routing();
        TypeParsers.parseField(builder, builder.name, routingNode, parserContext);
        for (Map.Entry<String, Object> entry : routingNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (fieldName.equals("required")) {
                builder.required(XContentMapValues.nodeBooleanValue(fieldNode));
                continue;
            }
            if (!fieldName.equals("path")) continue;
            builder.path(fieldNode.toString());
        }
        return builder;
    }

    private ParentFieldMapper.Builder parseParentField(Map<String, Object> parentNode, Mapper.TypeParser.ParserContext parserContext) {
        ParentFieldMapper.Builder builder = new ParentFieldMapper.Builder();
        for (Map.Entry<String, Object> entry : parentNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (!fieldName.equals("type")) continue;
            builder.type(fieldNode.toString());
        }
        return builder;
    }

    private AnalyzerMapper.Builder parseAnalyzerField(Map<String, Object> analyzerNode, Mapper.TypeParser.ParserContext parserContext) {
        AnalyzerMapper.Builder builder = MapperBuilders.analyzer();
        for (Map.Entry<String, Object> entry : analyzerNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (!fieldName.equals("path")) continue;
            builder.field(fieldNode.toString());
        }
        return builder;
    }

    private AllFieldMapper.Builder parseAllField(Map<String, Object> allNode, Mapper.TypeParser.ParserContext parserContext) {
        AllFieldMapper.Builder builder = MapperBuilders.all();
        TypeParsers.parseField(builder, builder.name, allNode, parserContext);
        for (Map.Entry<String, Object> entry : allNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (!fieldName.equals("enabled")) continue;
            builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
        }
        return builder;
    }

    private SizeFieldMapper.Builder parseSizeField(Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) {
        SizeFieldMapper.Builder builder = new SizeFieldMapper.Builder();
        for (Map.Entry<String, Object> entry : node.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (fieldName.equals("enabled")) {
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                continue;
            }
            if (!fieldName.equals("store")) continue;
            builder.store(TypeParsers.parseStore(fieldName, fieldNode.toString()));
        }
        return builder;
    }

    private SourceFieldMapper.Builder parseSourceField(Map<String, Object> sourceNode, Mapper.TypeParser.ParserContext parserContext) {
        SourceFieldMapper.Builder builder = MapperBuilders.source();
        for (Map.Entry<String, Object> entry : sourceNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (fieldName.equals("enabled")) {
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
                continue;
            }
            if (fieldName.equals("compress") && fieldNode != null) {
                builder.compress(XContentMapValues.nodeBooleanValue(fieldNode));
                continue;
            }
            if (!fieldName.equals("compress_threshold") || fieldNode == null) continue;
            if (fieldNode instanceof Number) {
                builder.compressThreshold(((Number)fieldNode).longValue());
                builder.compress(true);
                continue;
            }
            builder.compressThreshold(ByteSizeValue.parseBytesSizeValue(fieldNode.toString()).bytes());
            builder.compress(true);
        }
        return builder;
    }

    private IndexFieldMapper.Builder parseIndexField(Map<String, Object> indexNode, Mapper.TypeParser.ParserContext parserContext) {
        IndexFieldMapper.Builder builder = MapperBuilders.index();
        TypeParsers.parseField(builder, builder.name, indexNode, parserContext);
        for (Map.Entry<String, Object> entry : indexNode.entrySet()) {
            String fieldName = Strings.toUnderscoreCase(entry.getKey());
            Object fieldNode = entry.getValue();
            if (!fieldName.equals("enabled")) continue;
            builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
        }
        return builder;
    }

    private Tuple<String, Map<String, Object>> extractMapping(String type, String source) throws MapperParsingException {
        Map<String, Object> root;
        XContentParser xContentParser = null;
        try {
            xContentParser = XContentFactory.xContent(source).createParser(source);
            root = xContentParser.map();
        }
        catch (IOException e) {
            throw new MapperParsingException("Failed to parse mapping definition", e);
        }
        finally {
            if (xContentParser != null) {
                xContentParser.close();
            }
        }
        if (root.keySet().size() != 1) {
            throw new MapperParsingException("Mapping must have the `type` as the root object");
        }
        String rootName = root.keySet().iterator().next();
        if (type == null) {
            type = rootName;
        }
        return new Tuple<String, Map<String, Object>>(type, (Map)root.get(rootName));
    }
}

