/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;

public class ParsedDocument {
    private final String uid;
    private final String id;
    private final String type;
    private final String routing;
    private final List<Document> documents;
    private final Analyzer analyzer;
    private final byte[] source;
    private boolean mappersAdded;
    private String parent;

    public ParsedDocument(String uid, String id, String type, String routing, Document document, Analyzer analyzer, byte[] source, boolean mappersAdded) {
        this(uid, id, type, routing, Arrays.asList(document), analyzer, source, mappersAdded);
    }

    public ParsedDocument(String uid, String id, String type, String routing, List<Document> documents, Analyzer analyzer, byte[] source, boolean mappersAdded) {
        this.uid = uid;
        this.id = id;
        this.type = type;
        this.routing = routing;
        this.documents = documents;
        this.source = source;
        this.analyzer = analyzer;
        this.mappersAdded = mappersAdded;
    }

    public String uid() {
        return this.uid;
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public String routing() {
        return this.routing;
    }

    public Document rootDoc() {
        return this.documents.get(this.documents.size() - 1);
    }

    public List<Document> docs() {
        return this.documents;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    public byte[] source() {
        return this.source;
    }

    public ParsedDocument parent(String parent) {
        this.parent = parent;
        return this;
    }

    public String parent() {
        return this.parent;
    }

    public boolean mappersAdded() {
        return this.mappersAdded;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Document ").append("uid[").append(this.uid).append("] doc [").append(this.documents).append("]");
        return sb.toString();
    }
}

