/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericDateAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class DateFieldMapper
extends NumberFieldMapper<Long> {
    public static final String CONTENT_TYPE = "date";
    private final FormatDateTimeFormatter dateTimeFormatter;
    private String nullValue;

    protected DateFieldMapper(FieldMapper.Names names, FormatDateTimeFormatter dateTimeFormatter, int precisionStep, String fuzzyFactor, Field.Index index, Field.Store store, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, String nullValue) {
        super(names, precisionStep, fuzzyFactor, index, store, boost, omitNorms, omitTermFreqAndPositions, new NamedAnalyzer("_date/" + precisionStep, new NumericDateAnalyzer(precisionStep, dateTimeFormatter.parser())), new NamedAnalyzer("_date/max", new NumericDateAnalyzer(Integer.MAX_VALUE, dateTimeFormatter.parser())));
        this.dateTimeFormatter = dateTimeFormatter;
        this.nullValue = nullValue;
    }

    @Override
    protected double parseFuzzyFactor(String fuzzyFactor) {
        if (fuzzyFactor == null) {
            return 1.0;
        }
        try {
            return TimeValue.parseTimeValue(fuzzyFactor, null).millis();
        }
        catch (Exception e) {
            return Double.parseDouble(fuzzyFactor);
        }
    }

    @Override
    protected int maxPrecisionStep() {
        return 64;
    }

    @Override
    public Long value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return null;
        }
        return Numbers.bytesToLong(value);
    }

    @Override
    public Long valueFromString(String value) {
        return this.parseStringValue(value);
    }

    @Override
    public Object valueForSearch(Fieldable field) {
        return this.valueAsString(field);
    }

    @Override
    public String valueAsString(Fieldable field) {
        Long value = this.value(field);
        if (value == null) {
            return null;
        }
        return this.dateTimeFormatter.printer().print(value);
    }

    @Override
    public String indexedValue(String value) {
        return NumericUtils.longToPrefixCoded((long)this.dateTimeFormatter.parser().parseMillis(value));
    }

    @Override
    public Query fuzzyQuery(String value, String minSim, int prefixLength, int maxExpansions) {
        long iSim;
        long iValue = this.parseStringValue(value);
        try {
            iSim = TimeValue.parseTimeValue(minSim, null).millis();
        }
        catch (Exception e) {
            iSim = (long)Double.parseDouble(minSim);
        }
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(iValue - iSim), (Long)(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query fuzzyQuery(String value, double minSim, int prefixLength, int maxExpansions) {
        long iValue = this.parseStringValue(value);
        long iSim = (long)(minSim * this.dFuzzyFactor);
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(iValue - iSim), (Long)(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(lowerTerm == null ? null : Long.valueOf(this.parseStringValue(lowerTerm))), (Long)(upperTerm == null ? null : Long.valueOf(this.parseStringValue(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(lowerTerm == null ? null : Long.valueOf(this.parseStringValue(lowerTerm))), (Long)(upperTerm == null ? null : Long.valueOf(this.parseStringValue(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFieldDataFilter.newLongRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Long.valueOf(this.parseStringValue(lowerTerm)), upperTerm == null ? null : Long.valueOf(this.parseStringValue(upperTerm)), includeLower, includeUpper);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        LongFieldMapper.CustomLongNumericField field;
        String dateAsString = null;
        Long value = null;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue instanceof Number) {
                value = ((Number)externalValue).longValue();
            } else {
                dateAsString = (String)externalValue;
                if (dateAsString == null) {
                    dateAsString = this.nullValue;
                }
            }
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                dateAsString = this.nullValue;
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                value = parser.longValue();
            } else if (token == XContentParser.Token.START_OBJECT) {
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (token == XContentParser.Token.VALUE_NULL) {
                            dateAsString = this.nullValue;
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            value = parser.longValue();
                            continue;
                        }
                        dateAsString = parser.text();
                        continue;
                    }
                    if (!"boost".equals(currentFieldName) && !"_boost".equals(currentFieldName)) continue;
                    boost = parser.floatValue();
                }
            } else {
                dateAsString = parser.text();
            }
        }
        if (value != null) {
            field = new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, value);
            field.setBoost(boost);
            return field;
        }
        if (dateAsString == null) {
            return null;
        }
        if (context.includeInAll(this.includeInAll)) {
            context.allEntries().addText(this.names.fullName(), dateAsString, boost);
        }
        value = this.parseStringValue(dateAsString);
        field = new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, value);
        field.setBoost(boost);
        return field;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.LONG;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((DateFieldMapper)mergeWith).nullValue;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (!this.omitTermFreqAndPositions) {
            builder.field("omit_term_freq_and_positions", this.omitTermFreqAndPositions);
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.fuzzyFactor != Defaults.FUZZY_FACTOR) {
            builder.field("fuzzy_factor", this.fuzzyFactor);
        }
        builder.field("format", this.dateTimeFormatter.format());
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
    }

    private long parseStringValue(String value) {
        try {
            return this.dateTimeFormatter.parser().parseMillis(value);
        }
        catch (RuntimeException e) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e1) {
                throw new MapperParsingException("failed to parse date field, tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number", e);
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.dateField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    builder.nullValue(propNode.toString());
                    continue;
                }
                if (!propName.equals("format")) continue;
                builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propName, propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, DateFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;
        protected FormatDateTimeFormatter dateTimeFormatter = Defaults.DATE_TIME_FORMATTER;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return this;
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            DateFieldMapper fieldMapper = new DateFieldMapper(this.buildNames(context), this.dateTimeFormatter, this.precisionStep, this.fuzzyFactor, this.index, this.store, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.nullValue);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("dateOptionalTime");
        public static final String NULL_VALUE = null;
    }
}

