/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericFloatAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.FloatFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class BoostFieldMapper
extends NumberFieldMapper<Float>
implements InternalMapper {
    public static final String CONTENT_TYPE = "_boost";
    private final Float nullValue;

    public BoostFieldMapper() {
        this(CONTENT_TYPE, CONTENT_TYPE);
    }

    protected BoostFieldMapper(String name, String indexName) {
        this(name, indexName, 4, Defaults.INDEX, Defaults.STORE, 1.0f, true, true, Defaults.NULL_VALUE);
    }

    protected BoostFieldMapper(String name, String indexName, int precisionStep, Field.Index index, Field.Store store, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, Float nullValue) {
        super(new FieldMapper.Names(name, indexName, indexName, name), precisionStep, null, index, store, boost, omitNorms, omitTermFreqAndPositions, new NamedAnalyzer("_float/" + precisionStep, new NumericFloatAnalyzer(precisionStep)), new NamedAnalyzer("_float/max", new NumericFloatAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Float value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return null;
        }
        return Float.valueOf(Numbers.bytesToFloat(value));
    }

    @Override
    public Float valueFromString(String value) {
        return Float.valueOf(Float.parseFloat(value));
    }

    @Override
    public String indexedValue(String value) {
        return NumericUtils.floatToPrefixCoded((float)Float.parseFloat(value));
    }

    @Override
    public Query fuzzyQuery(String value, String minSim, int prefixLength, int maxExpansions) {
        float iValue = Float.parseFloat(value);
        float iSim = Float.parseFloat(minSim);
        return NumericRangeQuery.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)Float.valueOf(iValue - iSim), (Float)Float.valueOf(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query fuzzyQuery(String value, double minSim, int prefixLength, int maxExpansions) {
        float iValue = Float.parseFloat(value);
        float iSim = (float)(minSim * this.dFuzzyFactor);
        return NumericRangeQuery.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)Float.valueOf(iValue - iSim), (Float)Float.valueOf(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeQuery.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)(lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm))), (Float)(upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFilter.newFloatRange((String)this.names.indexName(), (int)this.precisionStep, (Float)(lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm))), (Float)(upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper) {
        return NumericRangeFieldDataFilter.newFloatRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Float.valueOf(Float.parseFloat(lowerTerm)), upperTerm == null ? null : Float.valueOf(Float.parseFloat(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        float value = this.parseFloatValue(context);
        if (!Float.isNaN(value)) {
            context.doc().setBoost(value);
        }
        super.parse(context);
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        float value = this.parseFloatValue(context);
        if (Float.isNaN(value)) {
            return null;
        }
        context.doc().setBoost(value);
        return new FloatFieldMapper.CustomFloatNumericField((NumberFieldMapper)this, value);
    }

    private float parseFloatValue(ParseContext context) throws IOException {
        float value;
        if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue == null) {
                return Float.NaN;
            }
            value = this.nullValue.floatValue();
        } else {
            value = context.parser().floatValue();
        }
        return value;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.FLOAT;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.name().equals(CONTENT_TYPE) && this.nullValue == null) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (!this.name().equals(CONTENT_TYPE)) {
            builder.field("name", this.name());
        }
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, BoostFieldMapper> {
        protected Float nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name);
            this.builder = this;
            this.index = Defaults.INDEX;
            this.store = Defaults.STORE;
        }

        public Builder nullValue(float nullValue) {
            this.nullValue = Float.valueOf(nullValue);
            return this;
        }

        @Override
        public BoostFieldMapper build(Mapper.BuilderContext context) {
            return new BoostFieldMapper(this.name, this.buildIndexName(context), this.precisionStep, this.index, this.store, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.nullValue);
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final String NAME = "_boost";
        public static final Float NULL_VALUE = null;
        public static final Field.Index INDEX = Field.Index.NO;
        public static final Field.Store STORE = Field.Store.NO;
    }
}

