/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.merge.scheduler;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.TrackingConcurrentMergeScheduler;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.policy.EnableMergePolicy;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class ConcurrentMergeSchedulerProvider
extends AbstractIndexShardComponent
implements MergeSchedulerProvider {
    private final int maxThreadCount;
    private Set<CustomConcurrentMergeScheduler> schedulers = new CopyOnWriteArraySet<CustomConcurrentMergeScheduler>();

    @Inject
    public ConcurrentMergeSchedulerProvider(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
        this.maxThreadCount = this.componentSettings.getAsInt("max_thread_count", Math.max(1, Math.min(3, Runtime.getRuntime().availableProcessors() / 2)));
        this.logger.debug("using [concurrent] merge scheduler with max_thread_count[{}]", this.maxThreadCount);
    }

    public MergeScheduler newMergeScheduler() {
        CustomConcurrentMergeScheduler concurrentMergeScheduler = new CustomConcurrentMergeScheduler(this.logger, this.shardId, this);
        concurrentMergeScheduler.setMaxThreadCount(this.maxThreadCount);
        this.schedulers.add(concurrentMergeScheduler);
        return concurrentMergeScheduler;
    }

    @Override
    public MergeStats stats() {
        MergeStats mergeStats = new MergeStats();
        for (CustomConcurrentMergeScheduler scheduler : this.schedulers) {
            mergeStats.add(scheduler.totalMerges(), scheduler.currentMerges(), scheduler.totalMergeTime());
        }
        return mergeStats;
    }

    public static class CustomConcurrentMergeScheduler
    extends TrackingConcurrentMergeScheduler {
        private final ShardId shardId;
        private final ConcurrentMergeSchedulerProvider provider;

        private CustomConcurrentMergeScheduler(ESLogger logger, ShardId shardId, ConcurrentMergeSchedulerProvider provider) {
            super(logger);
            this.shardId = shardId;
            this.provider = provider;
        }

        public void merge(IndexWriter writer) throws CorruptIndexException, IOException {
            try {
                if (writer.getConfig().getMergePolicy() instanceof EnableMergePolicy && !((EnableMergePolicy)writer.getConfig().getMergePolicy()).isMergeEnabled()) {
                    return;
                }
            }
            catch (AlreadyClosedException e) {
                return;
            }
            super.merge(writer);
        }

        protected ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
            ConcurrentMergeScheduler.MergeThread thread = super.getMergeThread(writer, merge);
            thread.setName("[" + this.shardId.index().name() + "][" + this.shardId.id() + "]: " + thread.getName());
            return thread;
        }

        public void close() {
            super.close();
            this.provider.schedulers.remove((Object)this);
        }
    }
}

