/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.function.BoostScoreFunction;
import org.elasticsearch.common.lucene.search.function.FiltersFunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.trove.list.array.TFloatArrayList;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.CustomScoreQueryParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.internal.SearchContext;

public class CustomFiltersScoreQueryParser
implements QueryParser {
    public static final String NAME = "custom_filters_score";

    @Inject
    public CustomFiltersScoreQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query query = null;
        float boost = 1.0f;
        String scriptLang = null;
        Map<String, Object> vars = null;
        FiltersFunctionScoreQuery.ScoreMode scoreMode = FiltersFunctionScoreQuery.ScoreMode.First;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        ArrayList<String> scripts = new ArrayList<String>();
        TFloatArrayList boosts = new TFloatArrayList();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    continue;
                }
                if (!"params".equals(currentFieldName)) continue;
                vars = parser.map();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!"filters".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    String script = null;
                    Filter filter = null;
                    float fboost = Float.NaN;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.START_OBJECT) {
                            if (!"filter".equals(currentFieldName)) continue;
                            filter = parseContext.parseInnerFilter();
                            continue;
                        }
                        if (!token.isValue()) continue;
                        if ("script".equals(currentFieldName)) {
                            script = parser.text();
                            continue;
                        }
                        if (!"boost".equals(currentFieldName)) continue;
                        fboost = parser.floatValue();
                    }
                    if (script == null && fboost == -1.0f) {
                        throw new QueryParsingException(parseContext.index(), "[custom_filters_score] missing 'script' or 'boost' in filters array element");
                    }
                    if (filter == null) {
                        throw new QueryParsingException(parseContext.index(), "[custom_filters_score] missing 'filter' in filters array element");
                    }
                    filters.add(filter);
                    scripts.add(script);
                    boosts.add(fboost);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("lang".equals(currentFieldName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (!"score_mode".equals(currentFieldName) && !"scoreMode".equals(currentFieldName)) continue;
            String sScoreMode = parser.text();
            if ("avg".equals(sScoreMode)) {
                scoreMode = FiltersFunctionScoreQuery.ScoreMode.Avg;
                continue;
            }
            if ("max".equals(sScoreMode)) {
                scoreMode = FiltersFunctionScoreQuery.ScoreMode.Max;
                continue;
            }
            if ("total".equals(sScoreMode)) {
                scoreMode = FiltersFunctionScoreQuery.ScoreMode.Total;
                continue;
            }
            if ("first".equals(sScoreMode)) {
                scoreMode = FiltersFunctionScoreQuery.ScoreMode.First;
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "illegal score_mode for nested query [" + sScoreMode + "]");
        }
        if (query == null) {
            throw new QueryParsingException(parseContext.index(), "[custom_filters_score] requires 'query' field");
        }
        if (filters.isEmpty()) {
            throw new QueryParsingException(parseContext.index(), "[custom_filters_score] requires 'filters' field");
        }
        SearchContext context = SearchContext.current();
        if (context == null) {
            throw new ElasticSearchIllegalStateException("No search context on going...");
        }
        FiltersFunctionScoreQuery.FilterFunction[] filterFunctions = new FiltersFunctionScoreQuery.FilterFunction[filters.size()];
        for (int i = 0; i < filterFunctions.length; ++i) {
            ScoreFunction scoreFunction;
            String script = (String)scripts.get(i);
            if (script != null) {
                SearchScript searchScript = context.scriptService().search(context.lookup(), scriptLang, script, vars);
                scoreFunction = new CustomScoreQueryParser.ScriptScoreFunction(searchScript);
            } else {
                scoreFunction = new BoostScoreFunction(boosts.get(i));
            }
            filterFunctions[i] = new FiltersFunctionScoreQuery.FilterFunction((Filter)filters.get(i), scoreFunction);
        }
        FiltersFunctionScoreQuery functionScoreQuery = new FiltersFunctionScoreQuery(query, scoreMode, filterFunctions);
        functionScoreQuery.setBoost(boost);
        return functionScoreQuery;
    }
}

