/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class FilteredQueryBuilder
extends BaseQueryBuilder {
    private final QueryBuilder queryBuilder;
    private final FilterBuilder filterBuilder;
    private float boost = -1.0f;

    public FilteredQueryBuilder(QueryBuilder queryBuilder, FilterBuilder filterBuilder) {
        this.queryBuilder = queryBuilder;
        this.filterBuilder = filterBuilder;
    }

    public FilteredQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("filtered");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("filter");
        this.filterBuilder.toXContent(builder, params);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

