/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class FilteredQueryParser
implements QueryParser {
    public static final String NAME = "filtered";

    @Inject
    public FilteredQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query query = null;
        Filter filter = null;
        float boost = 1.0f;
        boolean cache = false;
        CacheKeyFilter.Key cacheKey = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    continue;
                }
                if (!"filter".equals(currentFieldName)) continue;
                filter = parseContext.parseInnerFilter();
                continue;
            }
            if (!token.isValue()) continue;
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if (!"_cache_key".equals(currentFieldName) && !"_cacheKey".equals(currentFieldName)) continue;
            cacheKey = new CacheKeyFilter.Key(parser.text());
        }
        if (query == null) {
            throw new QueryParsingException(parseContext.index(), "[filtered] requires 'query' element");
        }
        if (filter == null) {
            throw new QueryParsingException(parseContext.index(), "[filtered] requires 'filter' element");
        }
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        if (Queries.isMatchAllQuery(query)) {
            DeletionAwareConstantScoreQuery q = new DeletionAwareConstantScoreQuery(filter);
            q.setBoost(boost);
            return q;
        }
        FilteredQuery filteredQuery = new FilteredQuery(query, filter);
        filteredQuery.setBoost(boost);
        return filteredQuery;
    }
}

