/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.nested.BlockJoinQuery;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.internal.SearchContext;

public class NestedQueryParser
implements QueryParser {
    public static final String NAME = "nested";
    static ThreadLocal<LateBindingParentFilter> parentFilterContext = new ThreadLocal();

    @Inject
    public NestedQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Filter childFilter;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        DeletionAwareConstantScoreQuery query = null;
        Filter filter = null;
        float boost = 1.0f;
        String scope = null;
        String path = null;
        BlockJoinQuery.ScoreMode scoreMode = BlockJoinQuery.ScoreMode.Avg;
        LateBindingParentFilter currentParentFilterContext = parentFilterContext.get();
        LateBindingParentFilter usAsParentFilter = new LateBindingParentFilter();
        parentFilterContext.set(usAsParentFilter);
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("query".equals(currentFieldName)) {
                    query = parseContext.parseInnerQuery();
                    continue;
                }
                if (!"filter".equals(currentFieldName)) continue;
                filter = parseContext.parseInnerFilter();
                continue;
            }
            if (!token.isValue()) continue;
            if ("path".equals(currentFieldName)) {
                path = parser.text();
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if ("_scope".equals(currentFieldName)) {
                scope = parser.text();
                continue;
            }
            if (!"score_mode".equals(currentFieldName) && !"scoreMode".equals((Object)scoreMode)) continue;
            String sScoreMode = parser.text();
            if ("avg".equals(sScoreMode)) {
                scoreMode = BlockJoinQuery.ScoreMode.Avg;
                continue;
            }
            if ("max".equals(sScoreMode)) {
                scoreMode = BlockJoinQuery.ScoreMode.Max;
                continue;
            }
            if ("total".equals(sScoreMode)) {
                scoreMode = BlockJoinQuery.ScoreMode.Total;
                continue;
            }
            if ("none".equals(sScoreMode)) {
                scoreMode = BlockJoinQuery.ScoreMode.None;
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "illegal score_mode for nested query [" + sScoreMode + "]");
        }
        if (query == null && filter == null) {
            throw new QueryParsingException(parseContext.index(), "[nested] requires either 'query' or 'filter' field");
        }
        if (path == null) {
            throw new QueryParsingException(parseContext.index(), "[nested] requires 'path' field");
        }
        if (filter != null) {
            query = new DeletionAwareConstantScoreQuery(filter);
        }
        query.setBoost(boost);
        MapperService.SmartNameObjectMapper mapper = parseContext.mapperService().smartNameObjectMapper(path);
        if (mapper == null) {
            throw new QueryParsingException(parseContext.index(), "[nested] failed to find nested object under path [" + path + "]");
        }
        ObjectMapper objectMapper = mapper.mapper();
        if (objectMapper == null) {
            throw new QueryParsingException(parseContext.index(), "[nested] failed to find nested object under path [" + path + "]");
        }
        if (!objectMapper.nested().isNested()) {
            throw new QueryParsingException(parseContext.index(), "[nested] nested object under path [" + path + "] is not of nested type");
        }
        usAsParentFilter.filter = childFilter = parseContext.cacheFilter(objectMapper.nestedTypeFilter(), null);
        query = new FilteredQuery((Query)query, childFilter);
        Filter parentFilter = currentParentFilterContext;
        if (parentFilter == null) {
            parentFilter = NonNestedDocsFilter.INSTANCE;
            if (mapper.hasDocMapper()) {
                parentFilter = mapper.docMapper().typeFilter();
            }
            parentFilter = parseContext.cacheFilter(parentFilter, null);
        }
        parentFilterContext.set(currentParentFilterContext);
        BlockJoinQuery joinQuery = new BlockJoinQuery((Query)query, parentFilter, scoreMode);
        if (scope != null) {
            SearchContext.current().addNestedQuery(scope, joinQuery);
        }
        return joinQuery;
    }

    static class LateBindingParentFilter
    extends Filter {
        Filter filter;

        LateBindingParentFilter() {
        }

        public int hashCode() {
            return this.filter.hashCode();
        }

        public boolean equals(Object obj) {
            return this.filter.equals(obj);
        }

        public String toString() {
            return this.filter.toString();
        }

        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            return this.filter.getDocIdSet(reader);
        }
    }
}

