/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.queryParser.MapperQueryParser;
import org.apache.lucene.queryParser.MultiFieldQueryParserSettings;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class QueryStringQueryParser
implements QueryParser {
    public static final String NAME = "query_string";

    @Inject
    public QueryStringQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        MapperQueryParser queryParser;
        Query query;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        MultiFieldQueryParserSettings qpSettings = new MultiFieldQueryParserSettings();
        qpSettings.defaultField("_all");
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!"fields".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    String fField = null;
                    float fBoost = -1.0f;
                    char[] text = parser.textCharacters();
                    int end = parser.textOffset() + parser.textLength();
                    for (int i = parser.textOffset(); i < end; ++i) {
                        if (text[i] != '^') continue;
                        int relativeLocation = i - parser.textOffset();
                        fField = new String(text, parser.textOffset(), relativeLocation);
                        fBoost = Float.parseFloat(new String(text, i + 1, parser.textLength() - relativeLocation - 1));
                        break;
                    }
                    if (fField == null) {
                        fField = parser.text();
                    }
                    if (qpSettings.fields() == null) {
                        qpSettings.fields(Lists.<String>newArrayList());
                    }
                    if (Regex.isSimpleMatchPattern(fField)) {
                        for (String field : parseContext.mapperService().simpleMatchToIndexNames(fField)) {
                            qpSettings.fields().add(field);
                            if (fBoost == -1.0f) continue;
                            if (qpSettings.boosts() == null) {
                                qpSettings.boosts(new TObjectFloatHashMap<String>(10, 0.5f, 1.0f));
                            }
                            qpSettings.boosts().put(field, fBoost);
                        }
                        continue;
                    }
                    qpSettings.fields().add(fField);
                    if (fBoost == -1.0f) continue;
                    if (qpSettings.boosts() == null) {
                        qpSettings.boosts(new TObjectFloatHashMap<String>(10, 0.5f, 1.0f));
                    }
                    qpSettings.boosts().put(fField, fBoost);
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("query".equals(currentFieldName)) {
                qpSettings.queryString(parser.text());
                continue;
            }
            if ("default_field".equals(currentFieldName) || "defaultField".equals(currentFieldName)) {
                qpSettings.defaultField(parseContext.indexName(parser.text()));
                continue;
            }
            if ("default_operator".equals(currentFieldName) || "defaultOperator".equals(currentFieldName)) {
                String op = parser.text();
                if ("or".equalsIgnoreCase(op)) {
                    qpSettings.defaultOperator(QueryParser.Operator.OR);
                    continue;
                }
                if ("and".equalsIgnoreCase(op)) {
                    qpSettings.defaultOperator(QueryParser.Operator.AND);
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "Query default operator [" + op + "] is not allowed");
            }
            if ("analyzer".equals(currentFieldName)) {
                qpSettings.analyzer(parseContext.analysisService().analyzer(parser.text()));
                continue;
            }
            if ("allow_leading_wildcard".equals(currentFieldName) || "allowLeadingWildcard".equals(currentFieldName)) {
                qpSettings.allowLeadingWildcard(parser.booleanValue());
                continue;
            }
            if ("auto_generate_phrase_queries".equals(currentFieldName) || "autoGeneratePhraseQueries".equals(currentFieldName)) {
                qpSettings.autoGeneratePhraseQueries(parser.booleanValue());
                continue;
            }
            if ("lowercase_expanded_terms".equals(currentFieldName) || "lowercaseExpandedTerms".equals(currentFieldName)) {
                qpSettings.lowercaseExpandedTerms(parser.booleanValue());
                continue;
            }
            if ("enable_position_increments".equals(currentFieldName) || "enablePositionIncrements".equals(currentFieldName)) {
                qpSettings.enablePositionIncrements(parser.booleanValue());
                continue;
            }
            if ("escape".equals(currentFieldName)) {
                qpSettings.escape(parser.booleanValue());
                continue;
            }
            if ("use_dis_max".equals(currentFieldName) || "useDisMax".equals(currentFieldName)) {
                qpSettings.useDisMax(parser.booleanValue());
                continue;
            }
            if ("fuzzy_prefix_length".equals(currentFieldName) || "fuzzyPrefixLength".equals(currentFieldName)) {
                qpSettings.fuzzyPrefixLength(parser.intValue());
                continue;
            }
            if ("phrase_slop".equals(currentFieldName) || "phraseSlop".equals(currentFieldName)) {
                qpSettings.phraseSlop(parser.intValue());
                continue;
            }
            if ("fuzzy_min_sim".equals(currentFieldName) || "fuzzyMinSim".equals(currentFieldName)) {
                qpSettings.fuzzyMinSim(parser.floatValue());
                continue;
            }
            if ("boost".equals(currentFieldName)) {
                qpSettings.boost(parser.floatValue());
                continue;
            }
            if ("tie_breaker".equals(currentFieldName) || "tieBreaker".equals(currentFieldName)) {
                qpSettings.tieBreaker(parser.floatValue());
                continue;
            }
            if ("analyze_wildcard".equals(currentFieldName) || "analyzeWildcard".equals(currentFieldName)) {
                qpSettings.analyzeWildcard(parser.booleanValue());
                continue;
            }
            if (!"rewrite".equals(currentFieldName)) continue;
            qpSettings.rewriteMethod(QueryParsers.parseRewriteMethod(parser.textOrNull()));
        }
        if (qpSettings.queryString() == null) {
            throw new QueryParsingException(parseContext.index(), "query_string must be provided with a [query]");
        }
        if (qpSettings.analyzer() == null) {
            qpSettings.analyzer(parseContext.mapperService().searchAnalyzer());
        }
        if (qpSettings.escape()) {
            qpSettings.queryString(org.apache.lucene.queryParser.QueryParser.escape((String)qpSettings.queryString()));
        }
        if ((query = parseContext.indexCache().queryParserCache().get(qpSettings)) != null) {
            return query;
        }
        if (qpSettings.fields() != null) {
            if (qpSettings.fields().size() == 1) {
                qpSettings.defaultField(qpSettings.fields().get(0));
                queryParser = parseContext.singleQueryParser(qpSettings);
            } else {
                qpSettings.defaultField(null);
                queryParser = parseContext.multiQueryParser(qpSettings);
            }
        } else {
            queryParser = parseContext.singleQueryParser(qpSettings);
        }
        try {
            query = queryParser.parse(qpSettings.queryString());
            query.setBoost(qpSettings.boost());
            query = Queries.optimizeQuery(Queries.fixNegativeQueryIfNeeded(query));
            parseContext.indexCache().queryParserCache().put(qpSettings, query);
            return query;
        }
        catch (ParseException e) {
            throw new QueryParsingException(parseContext.index(), "Failed to parse query [" + qpSettings.queryString() + "]", e);
        }
    }
}

