/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PublicTermsFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class TermsFilterParser
implements FilterParser {
    public static final String NAME = "terms";

    @Inject
    public TermsFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, "in"};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        MapperService.SmartNameFieldMappers smartNameFieldMappers = null;
        boolean cache = true;
        PublicTermsFilter termsFilter = new PublicTermsFilter();
        String filterName = null;
        String currentFieldName = null;
        CacheKeyFilter.Key cacheKey = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                String fieldName = currentFieldName;
                FieldMapper fieldMapper = null;
                smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
                if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
                    fieldMapper = smartNameFieldMappers.mapper();
                    fieldName = fieldMapper.names().indexName();
                }
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    String value = parser.text();
                    if (value == null) {
                        throw new QueryParsingException(parseContext.index(), "No value specified for term filter");
                    }
                    if (fieldMapper != null) {
                        value = fieldMapper.indexedValue(value);
                    }
                    termsFilter.addTerm(new Term(fieldName, value));
                }
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            if ("_cache".equals(currentFieldName)) {
                cache = parser.booleanValue();
                continue;
            }
            if (!"_cache_key".equals(currentFieldName) && !"_cacheKey".equals(currentFieldName)) continue;
            cacheKey = new CacheKeyFilter.Key(parser.text());
        }
        PublicTermsFilter filter = termsFilter;
        if (cache) {
            filter = parseContext.cacheFilter(filter, cacheKey);
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartNameFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, filter);
        }
        return filter;
    }
}

