/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.lucene.docset.GetDocSet;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.geo.GeoPointFieldDataType;
import org.elasticsearch.index.search.geo.GeoDistance;

public class GeoDistanceFilter
extends Filter {
    private final double lat;
    private final double lon;
    private final double distance;
    private final GeoDistance geoDistance;
    private final String fieldName;
    private final FieldDataCache fieldDataCache;

    public GeoDistanceFilter(double lat, double lon, double distance, GeoDistance geoDistance, String fieldName, FieldDataCache fieldDataCache) {
        this.lat = lat;
        this.lon = lon;
        this.distance = distance;
        this.geoDistance = geoDistance;
        this.fieldName = fieldName;
        this.fieldDataCache = fieldDataCache;
    }

    public double lat() {
        return this.lat;
    }

    public double lon() {
        return this.lon;
    }

    public double distance() {
        return this.distance;
    }

    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final GeoPointFieldData fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.fieldName);
        return new GetDocSet(reader.maxDoc()){

            public boolean isCacheable() {
                return false;
            }

            @Override
            public boolean get(int doc) throws IOException {
                if (!fieldData.hasValue(doc)) {
                    return false;
                }
                if (fieldData.multiValued()) {
                    double[] lats = fieldData.latValues(doc);
                    double[] lons = fieldData.lonValues(doc);
                    for (int i = 0; i < lats.length; ++i) {
                        double d = GeoDistanceFilter.this.geoDistance.calculate(GeoDistanceFilter.this.lat, GeoDistanceFilter.this.lon, lats[i], lons[i], DistanceUnit.MILES);
                        if (!(d < GeoDistanceFilter.this.distance)) continue;
                        return true;
                    }
                    return false;
                }
                double d = GeoDistanceFilter.this.geoDistance.calculate(GeoDistanceFilter.this.lat, GeoDistanceFilter.this.lon, fieldData.latValue(doc), fieldData.lonValue(doc), DistanceUnit.MILES);
                return d < GeoDistanceFilter.this.distance;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GeoDistanceFilter filter = (GeoDistanceFilter)((Object)o);
        if (Double.compare(filter.distance, this.distance) != 0) {
            return false;
        }
        if (Double.compare(filter.lat, this.lat) != 0) {
            return false;
        }
        if (Double.compare(filter.lon, this.lon) != 0) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(filter.fieldName) : filter.fieldName != null) {
            return false;
        }
        return this.geoDistance == filter.geoDistance;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon != 0.0 ? Double.doubleToLongBits(this.lon) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.distance != 0.0 ? Double.doubleToLongBits(this.distance) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.geoDistance != null ? this.geoDistance.hashCode() : 0);
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }
}

