/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.nested;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.OpenBitSet;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.lucene.docset.OpenBitDocSet;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetCollector;

public class NestedChildrenCollector
extends FacetCollector {
    private final FacetCollector collector;
    private final Filter parentFilter;
    private final Filter childFilter;
    private DocSet childDocs;
    private OpenBitSet parentDocs;
    private IndexReader currentReader;

    public NestedChildrenCollector(FacetCollector collector, Filter parentFilter, Filter childFilter) {
        this.collector = collector;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    @Override
    public Facet facet() {
        return this.collector.facet();
    }

    @Override
    public void setFilter(Filter filter) {
        this.collector.setFilter(filter);
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.collector.setScorer(scorer);
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.collector.setNextReader(reader, docBase);
        this.currentReader = reader;
        this.childDocs = DocSets.convert(reader, this.childFilter.getDocIdSet(reader));
        this.parentDocs = ((OpenBitDocSet)this.parentFilter.getDocIdSet(reader)).set();
    }

    public boolean acceptsDocsOutOfOrder() {
        return this.collector.acceptsDocsOutOfOrder();
    }

    public void collect(int parentDoc) throws IOException {
        int prevParentDoc = this.parentDocs.prevSetBit(parentDoc - 1);
        for (int i = parentDoc - 1; i > prevParentDoc; --i) {
            if (this.currentReader.isDeleted(i) || !this.childDocs.get(i)) continue;
            this.collector.collect(i);
        }
    }
}

