/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.fs;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NIOFSDirectory;
import org.elasticsearch.cache.memory.ByteBufferCache;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.lucene.store.SwitchDirectory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.fs.FsIndexStore;
import org.elasticsearch.index.store.fs.FsStore;

public class NioFsStore
extends FsStore {
    private final NIOFSDirectory fsDirectory;
    private final Directory directory;
    private final boolean suggestUseCompoundFile;

    @Inject
    public NioFsStore(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore, ByteBufferCache byteBufferCache) throws IOException {
        super(shardId, indexSettings, indexStore);
        boolean suggestUseCompoundFile;
        LockFactory lockFactory = this.buildLockFactory();
        File location = ((FsIndexStore)indexStore).shardIndexLocation(shardId);
        FileSystemUtils.mkdirs(location);
        this.fsDirectory = new NIOFSDirectory(location, lockFactory);
        Tuple<SwitchDirectory, Boolean> switchDirectory = this.buildSwitchDirectoryIfNeeded((Directory)this.fsDirectory, byteBufferCache);
        if (switchDirectory != null) {
            suggestUseCompoundFile = false;
            if (switchDirectory.v2() != null) {
                suggestUseCompoundFile = switchDirectory.v2();
            }
            this.logger.debug("using [nio_fs] store with path [{}], cache [true] with extensions [{}]", this.fsDirectory.getDirectory(), switchDirectory.v1().primaryExtensions());
            this.directory = this.wrapDirectory(switchDirectory.v1());
        } else {
            suggestUseCompoundFile = false;
            this.directory = this.wrapDirectory((Directory)this.fsDirectory);
            this.logger.debug("using [nio_fs] store with path [{}]", this.fsDirectory.getDirectory());
        }
        this.suggestUseCompoundFile = suggestUseCompoundFile;
    }

    @Override
    public FSDirectory fsDirectory() {
        return this.fsDirectory;
    }

    @Override
    public Directory directory() {
        return this.directory;
    }

    @Override
    public boolean suggestUseCompoundFile() {
        return this.suggestUseCompoundFile;
    }
}

