/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.memory;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.bytebuffer.ByteBufferAllocator;
import org.apache.lucene.store.bytebuffer.ByteBufferDirectory;
import org.apache.lucene.store.bytebuffer.ByteBufferFile;
import org.elasticsearch.cache.memory.ByteBufferCache;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.support.AbstractStore;

public class ByteBufferStore
extends AbstractStore {
    private final CustomByteBufferDirectory bbDirectory;
    private final Directory directory;

    @Inject
    public ByteBufferStore(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore, ByteBufferCache byteBufferCache) throws IOException {
        super(shardId, indexSettings, indexStore);
        this.bbDirectory = new CustomByteBufferDirectory(byteBufferCache);
        this.directory = this.wrapDirectory(this.bbDirectory);
        this.logger.debug("Using [byte_buffer] store", new Object[0]);
    }

    @Override
    public Directory directory() {
        return this.directory;
    }

    @Override
    public boolean suggestUseCompoundFile() {
        return false;
    }

    @Override
    protected void doRenameFile(String from, String to) throws IOException {
        this.bbDirectory.renameTo(from, to);
    }

    static class CustomByteBufferDirectory
    extends ByteBufferDirectory {
        CustomByteBufferDirectory() {
        }

        CustomByteBufferDirectory(ByteBufferAllocator allocator) {
            super(allocator);
        }

        public void renameTo(String from, String to) throws IOException {
            ByteBufferFile fromFile = (ByteBufferFile)this.files.get(from);
            if (fromFile == null) {
                throw new FileNotFoundException(from);
            }
            ByteBufferFile toFile = (ByteBufferFile)this.files.get(to);
            if (toFile != null) {
                this.files.remove(from);
            }
            this.files.put(to, fromFile);
        }
    }
}

