/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import org.elasticsearch.common.BytesHolder;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.translog.Translog;

public class TranslogStreams {
    public static Translog.Operation readTranslogOperation(StreamInput in) throws IOException {
        Translog.Operation operation;
        Translog.Operation.Type type = Translog.Operation.Type.fromId(in.readByte());
        switch (type) {
            case CREATE: {
                operation = new Translog.Create();
                break;
            }
            case DELETE: {
                operation = new Translog.Delete();
                break;
            }
            case DELETE_BY_QUERY: {
                operation = new Translog.DeleteByQuery();
                break;
            }
            case SAVE: {
                operation = new Translog.Index();
                break;
            }
            default: {
                throw new IOException("No type for [" + (Object)((Object)type) + "]");
            }
        }
        operation.readFrom(in);
        return operation;
    }

    public static BytesHolder readSource(byte[] data) throws IOException {
        Translog.Operation operation;
        BytesStreamInput in = new BytesStreamInput(data);
        in.readInt();
        Translog.Operation.Type type = Translog.Operation.Type.fromId(in.readByte());
        switch (type) {
            case CREATE: {
                operation = new Translog.Create();
                break;
            }
            case DELETE: {
                operation = new Translog.Delete();
                break;
            }
            case DELETE_BY_QUERY: {
                operation = new Translog.DeleteByQuery();
                break;
            }
            case SAVE: {
                operation = new Translog.Index();
                break;
            }
            default: {
                throw new IOException("No type for [" + (Object)((Object)type) + "]");
            }
        }
        return operation.readSource(in);
    }

    public static void writeTranslogOperation(StreamOutput out, Translog.Operation op) throws IOException {
        out.writeByte(op.opType().id());
        op.writeTo(out);
    }
}

