/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog.fs;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogException;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.fs.FsChannelSnapshot;
import org.elasticsearch.index.translog.fs.FsTranslogFile;
import org.elasticsearch.index.translog.fs.RafReference;

public class FsTranslog
extends AbstractIndexShardComponent
implements Translog {
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final File location;
    private volatile FsTranslogFile current;
    private volatile FsTranslogFile trans;
    private boolean syncOnEachOperation = false;

    @Inject
    public FsTranslog(ShardId shardId, @IndexSettings Settings indexSettings, NodeEnvironment nodeEnv) {
        super(shardId, indexSettings);
        this.location = new File(nodeEnv.shardLocation(shardId), "translog");
        FileSystemUtils.mkdirs(this.location);
    }

    public FsTranslog(ShardId shardId, @IndexSettings Settings indexSettings, File location) {
        super(shardId, indexSettings);
        this.location = location;
        FileSystemUtils.mkdirs(this.location);
    }

    public File location() {
        return this.location;
    }

    @Override
    public long currentId() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return -1L;
        }
        return current1.id();
    }

    @Override
    public int estimatedNumberOfOperations() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return 0;
        }
        return current1.estimatedNumberOfOperations();
    }

    @Override
    public long memorySizeInBytes() {
        return 0L;
    }

    @Override
    public long translogSizeInBytes() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return 0L;
        }
        return current1.translogSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearUnreferenced() {
        this.rwl.writeLock().lock();
        try {
            File[] files = this.location.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.getName().equals("translog-" + this.current.id()) || this.trans != null && file.getName().equals("translog-" + this.trans.id())) continue;
                    try {
                        file.delete();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newTranslog(long id) throws TranslogException {
        this.rwl.writeLock().lock();
        try {
            FsTranslogFile newFile;
            try {
                newFile = new FsTranslogFile(this.shardId, id, new RafReference(new File(this.location, "translog-" + id)));
            }
            catch (IOException e) {
                throw new TranslogException(this.shardId, "failed to create new translog file", (Throwable)e);
            }
            FsTranslogFile old = this.current;
            this.current = newFile;
            if (old != null) {
                boolean delete = true;
                if (old.id() == id) {
                    delete = false;
                }
                old.close(delete);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public void newTransientTranslog(long id) throws TranslogException {
        this.rwl.writeLock().lock();
        try {
            assert (this.trans == null);
            this.trans = new FsTranslogFile(this.shardId, id, new RafReference(new File(this.location, "translog-" + id)));
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to create new translog file", (Throwable)e);
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeTransientCurrent() {
        FsTranslogFile old;
        this.rwl.writeLock().lock();
        try {
            assert (this.trans != null);
            old = this.current;
            this.current = this.trans;
            this.trans = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        old.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revertTransient() {
        FsTranslogFile old;
        this.rwl.writeLock().lock();
        try {
            old = this.trans;
            this.trans = null;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        old.close(true);
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] read(Translog.Location location) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Translog.Location add(Translog.Operation operation) throws TranslogException {
        CachedStreamOutput.Entry cachedEntry = CachedStreamOutput.popEntry();
        this.rwl.readLock().lock();
        try {
            FsTranslogFile trans;
            BytesStreamOutput out = cachedEntry.cachedBytes();
            out.writeInt(0);
            TranslogStreams.writeTranslogOperation(out, operation);
            out.flush();
            int size = out.size();
            out.seek(0);
            out.writeInt(size - 4);
            Translog.Location location = this.current.add(out.unsafeByteArray(), 0, size);
            if (this.syncOnEachOperation) {
                this.current.sync();
            }
            if ((trans = this.trans) != null) {
                try {
                    location = trans.add(out.unsafeByteArray(), 0, size);
                }
                catch (ClosedChannelException e) {
                    // empty catch block
                }
            }
            Translog.Location location2 = location;
            return location2;
        }
        catch (Exception e) {
            throw new TranslogException(this.shardId, "Failed to write operation [" + operation + "]", (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
            CachedStreamOutput.pushEntry(cachedEntry);
        }
    }

    @Override
    public FsChannelSnapshot snapshot() throws TranslogException {
        FsChannelSnapshot snapshot;
        while ((snapshot = this.current.snapshot()) == null) {
            Thread.yield();
        }
        return snapshot;
    }

    @Override
    public Translog.Snapshot snapshot(Translog.Snapshot snapshot) {
        FsChannelSnapshot snap = this.snapshot();
        if (snap.translogId() == snapshot.translogId()) {
            snap.seekForward(snapshot.position());
        }
        return snap;
    }

    @Override
    public void sync() {
        FsTranslogFile current1 = this.current;
        if (current1 == null) {
            return;
        }
        current1.sync();
    }

    @Override
    public void syncOnEachOperation(boolean syncOnEachOperation) {
        this.syncOnEachOperation = syncOnEachOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean delete) {
        this.rwl.writeLock().lock();
        try {
            FsTranslogFile current1 = this.current;
            if (current1 != null) {
                current1.close(delete);
            }
            if ((current1 = this.trans) != null) {
                current1.close(delete);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }
}

