/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.SpawnModules;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.recovery.RecoverySource;
import org.elasticsearch.index.shard.recovery.RecoveryTarget;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.InternalIndicesService;
import org.elasticsearch.indices.analysis.IndicesAnalysisModule;
import org.elasticsearch.indices.cache.filter.IndicesNodeFilterCache;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.memory.IndexingMemoryBufferController;
import org.elasticsearch.indices.query.IndicesQueriesModule;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;

public class IndicesModule
extends AbstractModule
implements SpawnModules {
    private final Settings settings;

    public IndicesModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    public Iterable<? extends Module> spawnModules() {
        return ImmutableList.of(new IndicesQueriesModule(), new IndicesAnalysisModule());
    }

    @Override
    protected void configure() {
        this.bind(IndicesLifecycle.class).to(InternalIndicesLifecycle.class).asEagerSingleton();
        this.bind(IndicesService.class).to(InternalIndicesService.class).asEagerSingleton();
        this.bind(RecoveryTarget.class).asEagerSingleton();
        this.bind(RecoverySource.class).asEagerSingleton();
        this.bind(IndicesClusterStateService.class).asEagerSingleton();
        this.bind(IndexingMemoryBufferController.class).asEagerSingleton();
        this.bind(IndicesNodeFilterCache.class).asEagerSingleton();
        this.bind(TransportNodesListShardStoreMetaData.class).asEagerSingleton();
    }
}

