/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.jvm;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.monitor.dump.DumpGenerator;
import org.elasticsearch.monitor.dump.DumpMonitorService;
import org.elasticsearch.monitor.jvm.DeadlockAnalyzer;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.threadpool.ThreadPool;

public class JvmMonitorService
extends AbstractLifecycleComponent<JvmMonitorService> {
    private final ThreadPool threadPool;
    private final DumpMonitorService dumpMonitorService;
    private final boolean enabled;
    private final TimeValue interval;
    private final TimeValue gcThreshold;
    private volatile ScheduledFuture scheduledFuture;

    @Inject
    public JvmMonitorService(Settings settings, ThreadPool threadPool, DumpMonitorService dumpMonitorService) {
        super(settings);
        this.threadPool = threadPool;
        this.dumpMonitorService = dumpMonitorService;
        this.enabled = this.componentSettings.getAsBoolean("enabled", JvmStats.isLastGcEnabled());
        this.interval = this.componentSettings.getAsTime("interval", TimeValue.timeValueSeconds(1L));
        this.gcThreshold = this.componentSettings.getAsTime("gc_threshold", TimeValue.timeValueMillis(5000L));
        this.logger.debug("enabled [{}], last_gc_enabled [{}], interval [{}], gc_threshold [{}]", this.enabled, JvmStats.isLastGcEnabled(), this.interval, this.gcThreshold);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
        if (!this.enabled) {
            return;
        }
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(new JvmMonitor(), this.interval);
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        if (!this.enabled) {
            return;
        }
        this.scheduledFuture.cancel(true);
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    private class JvmMonitor
    implements Runnable {
        private JvmStats lastJvmStats = JvmStats.jvmStats();
        private final Set<DeadlockAnalyzer.Deadlock> lastSeenDeadlocks = new HashSet<DeadlockAnalyzer.Deadlock>();

        @Override
        public void run() {
            this.monitorLongGc();
        }

        private void monitorLongGc() {
            JvmStats currentJvmStats = JvmStats.jvmStats();
            for (int i = 0; i < currentJvmStats.gc().collectors().length; ++i) {
                JvmStats.GarbageCollector gc = currentJvmStats.gc().collectors()[i];
                if (gc.lastGc() != null && this.lastJvmStats.gc.collectors()[i].lastGc() != null) {
                    JvmStats.GarbageCollector.LastGc lastGc = gc.lastGc();
                    if (lastGc.startTime == this.lastJvmStats.gc.collectors()[i].lastGc().startTime() || lastGc.duration().hoursFrac() > 1.0) continue;
                    if (lastGc.duration().millis() > JvmMonitorService.this.gcThreshold.millis()) {
                        JvmMonitorService.this.logger.info("[gc][{}][{}] took [{}]/[{}], reclaimed [{}], leaving [{}] used, max [{}]", gc.name(), gc.getCollectionCount(), lastGc.duration(), gc.getCollectionTime(), lastGc.reclaimed(), lastGc.afterUsed(), lastGc.max());
                        continue;
                    }
                    if (!JvmMonitorService.this.logger.isDebugEnabled()) continue;
                    JvmMonitorService.this.logger.debug("[gc][{}][{}] took [{}]/[{}], reclaimed [{}], leaving [{}] used, max [{}]", gc.name(), gc.getCollectionCount(), lastGc.duration(), gc.getCollectionTime(), lastGc.reclaimed(), lastGc.afterUsed(), lastGc.max());
                    continue;
                }
                long collectionTime = gc.collectionTime().millis() - this.lastJvmStats.gc().collectors()[i].collectionTime().millis();
                if (collectionTime <= JvmMonitorService.this.gcThreshold.millis()) continue;
                JvmMonitorService.this.logger.info("[gc][{}] collection occurred, took [{}]", gc.name(), new TimeValue(collectionTime));
            }
            this.lastJvmStats = currentJvmStats;
        }

        private void monitorDeadlock() {
            Object[] deadlocks = DeadlockAnalyzer.deadlockAnalyzer().findDeadlocks();
            if (deadlocks != null && deadlocks.length > 0) {
                ImmutableCollection asSet = ((ImmutableSet.Builder)new ImmutableSet.Builder().add(deadlocks)).build();
                if (!((ImmutableSet)asSet).equals(this.lastSeenDeadlocks)) {
                    DumpGenerator.Result genResult = JvmMonitorService.this.dumpMonitorService.generateDump("deadlock", null, "summary", "thread");
                    StringBuilder sb = new StringBuilder("Detected Deadlock(s)");
                    for (DeadlockAnalyzer.Deadlock deadlock : asSet) {
                        sb.append("\n   ----> ").append(deadlock);
                    }
                    sb.append("\nDump generated [").append(genResult.location()).append("]");
                    JvmMonitorService.this.logger.error(sb.toString(), new Object[0]);
                    this.lastSeenDeadlocks.clear();
                    this.lastSeenDeadlocks.addAll(asSet);
                }
            } else {
                this.lastSeenDeadlocks.clear();
            }
        }
    }
}

