/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.http.client.HttpDownloadHelper;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.internal.InternalSettingsPerparer;

public class PluginManager {
    private final Environment environment;
    private String url;

    public PluginManager(Environment environment, String url) {
        this.environment = environment;
        this.url = url;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadAndExtract(String name) throws IOException {
        HttpDownloadHelper downloadHelper = new HttpDownloadHelper();
        File pluginFile = new File(this.url + "/" + name + "/elasticsearch-" + name + "-" + Version.number() + ".zip");
        boolean downloaded = false;
        String filterZipName = null;
        if (!pluginFile.exists()) {
            pluginFile = new File(this.url + "/elasticsearch-" + name + "-" + Version.number() + ".zip");
            if (!pluginFile.exists()) {
                URL pluginUrl;
                pluginFile = new File(this.environment.pluginsFile(), name + ".zip");
                if (this.url != null) {
                    pluginUrl = new URL(this.url);
                    System.out.println("Trying " + pluginUrl.toExternalForm() + "...");
                    try {
                        downloadHelper.download(pluginUrl, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                        downloaded = true;
                    }
                    catch (IOException e) {}
                } else {
                    this.url = "http://elasticsearch.googlecode.com/svn/plugins";
                }
                if (!downloaded) {
                    if (name.indexOf(47) != -1) {
                        URL pluginUrl2;
                        String[] elements = name.split("/");
                        String userName = elements[0];
                        String repoName = elements[1];
                        String version = null;
                        if (elements.length > 2) {
                            version = elements[2];
                        }
                        filterZipName = userName + "-" + repoName;
                        name = repoName;
                        if (name.startsWith("elasticsearch-")) {
                            name = name.substring("elasticsearch-".length());
                        } else if (name.startsWith("es-")) {
                            name = name.substring("es-".length());
                        }
                        pluginFile = new File(this.environment.pluginsFile(), name + ".zip");
                        if (version == null) {
                            pluginUrl2 = new URL("https://github.com/downloads/" + userName + "/" + repoName + "/" + repoName + "-" + Version.number() + ".zip");
                            System.out.println("Trying " + pluginUrl2.toExternalForm() + "...");
                            try {
                                downloadHelper.download(pluginUrl2, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                                downloaded = true;
                            }
                            catch (IOException e) {
                                pluginUrl2 = new URL("https://github.com/" + userName + "/" + repoName + "/zipball/v" + Version.number());
                                System.out.println("Trying " + pluginUrl2.toExternalForm() + "...");
                                try {
                                    downloadHelper.download(pluginUrl2, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                                    downloaded = true;
                                }
                                catch (IOException e1) {
                                    pluginUrl2 = new URL("https://github.com/" + userName + "/" + repoName + "/zipball/master");
                                    System.out.println("Trying " + pluginUrl2.toExternalForm() + "...");
                                    try {
                                        downloadHelper.download(pluginUrl2, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                                        downloaded = true;
                                    }
                                    catch (IOException e2) {}
                                }
                            }
                        } else {
                            pluginUrl2 = new URL("https://github.com/downloads/" + userName + "/" + repoName + "/" + repoName + "-" + version + ".zip");
                            System.out.println("Trying " + pluginUrl2.toExternalForm() + "...");
                            try {
                                downloadHelper.download(pluginUrl2, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                                downloaded = true;
                            }
                            catch (IOException e) {
                                pluginUrl2 = new URL("https://github.com/" + userName + "/" + repoName + "/zipball/v" + version);
                                System.out.println("Trying " + pluginUrl2.toExternalForm() + "...");
                                try {
                                    downloadHelper.download(pluginUrl2, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                                    downloaded = true;
                                }
                                catch (IOException e1) {}
                            }
                        }
                    } else {
                        pluginUrl = new URL(this.url + "/" + name + "/elasticsearch-" + name + "-" + Version.number() + ".zip");
                        System.out.println("Trying " + pluginUrl.toExternalForm() + "...");
                        try {
                            downloadHelper.download(pluginUrl, pluginFile, new HttpDownloadHelper.VerboseProgress(System.out));
                            downloaded = true;
                        }
                        catch (IOException e) {}
                    }
                }
            } else {
                System.out.println("Using plugin from local fs: " + pluginFile.getAbsolutePath());
                downloaded = true;
            }
        } else {
            System.out.println("Using plugin from local fs: " + pluginFile.getAbsolutePath());
            downloaded = true;
        }
        if (!downloaded) {
            throw new IOException("failed to download");
        }
        File extractLocation = new File(this.environment.pluginsFile(), name);
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(pluginFile);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                if (zipEntry.isDirectory()) continue;
                String zipName = zipEntry.getName().replace('\\', '/');
                if (filterZipName != null && zipName.startsWith(filterZipName)) {
                    zipName = zipName.substring(zipName.indexOf(47));
                }
                File target = new File(extractLocation, zipName);
                FileSystemUtils.mkdirs(target.getParentFile());
                Streams.copy(zipFile.getInputStream(zipEntry), (OutputStream)new FileOutputStream(target));
            }
        }
        catch (Exception e) {
            System.err.println("failed to extract plugin [" + pluginFile + "]");
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
            pluginFile.delete();
        }
        if (!new File(extractLocation, "_site").exists() && !FileSystemUtils.hasExtensions(extractLocation, ".class", ".jar")) {
            System.out.println("Identified as a _site plugin, moving to _site structure ...");
            File site = new File(extractLocation, "_site");
            File tmpLocation = new File(this.environment.pluginsFile(), name + ".tmp");
            extractLocation.renameTo(tmpLocation);
            FileSystemUtils.mkdirs(extractLocation);
            tmpLocation.renameTo(site);
        }
        System.out.println("Installed " + name);
    }

    public void removePlugin(String name) throws IOException {
        File pluginToDelete = new File(this.environment.pluginsFile(), name);
        if (pluginToDelete.exists()) {
            FileSystemUtils.deleteRecursively(pluginToDelete, true);
        }
        if ((pluginToDelete = new File(this.environment.pluginsFile(), name + ".zip")).exists()) {
            pluginToDelete.delete();
        }
    }

    public static void main(String[] args) {
        Tuple<Settings, Environment> initialSettings = InternalSettingsPerparer.prepareSettings(ImmutableSettings.Builder.EMPTY_SETTINGS, true);
        if (!initialSettings.v2().pluginsFile().exists()) {
            FileSystemUtils.mkdirs(initialSettings.v2().pluginsFile());
        }
        String url = null;
        for (int i = 0; i < args.length; ++i) {
            if (!"url".equals(args[i]) && !"-url".equals(args[i])) continue;
            url = args[i + 1];
            break;
        }
        PluginManager pluginManager = new PluginManager(initialSettings.v2(), url);
        if (args.length < 1) {
            System.out.println("Usage:");
            System.out.println("    -url     [plugins location]  : Set URL to download plugins from");
            System.out.println("    -install [plugin name]       : Downloads and installs listed plugins");
            System.out.println("    -remove  [plugin name]       : Removes listed plugins");
        }
        for (int c = 0; c < args.length; ++c) {
            String pluginName;
            String command = args[c];
            if (command.equals("install") || command.equals("-install")) {
                pluginName = args[++c];
                System.out.println("-> Installing " + pluginName + "...");
                try {
                    pluginManager.downloadAndExtract(pluginName);
                }
                catch (IOException e) {
                    System.out.println("Failed to install " + pluginName + ", reason: " + e.getMessage());
                }
                continue;
            }
            if (command.equals("remove") || command.equals("-remove")) {
                pluginName = args[++c];
                System.out.println("-> Removing " + pluginName + " ");
                try {
                    pluginManager.removePlugin(pluginName);
                }
                catch (IOException e) {
                    System.out.println("Failed to remove " + pluginName + ", reason: " + e.getMessage());
                }
                continue;
            }
            ++c;
        }
    }
}

