/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestNodesInfoAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;

    @Inject
    public RestNodesInfoAction(Settings settings, Client client, RestController controller, SettingsFilter settingsFilter) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/nodes", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cluster/nodes/{nodeId}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        String[] nodesIds = RestActions.splitNodes(request.param("nodeId"));
        final boolean includeSettings = request.paramAsBoolean("settings", false);
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(nodesIds);
        nodesInfoRequest.listenerThreaded(false);
        this.client.admin().cluster().nodesInfo(nodesInfoRequest, new ActionListener<NodesInfoResponse>(){

            @Override
            public void onResponse(NodesInfoResponse result) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.field("cluster_name", result.clusterName().value());
                    builder.startObject("nodes");
                    for (NodeInfo nodeInfo : result) {
                        builder.startObject(nodeInfo.node().id(), XContentBuilder.FieldCaseConversion.NONE);
                        builder.field("name", nodeInfo.node().name());
                        builder.field("transport_address", nodeInfo.node().address().toString());
                        builder.startObject("attributes");
                        for (Map.Entry attr : nodeInfo.node().attributes().entrySet()) {
                            builder.field((String)attr.getKey(), (String)attr.getValue());
                        }
                        builder.endObject();
                        for (Map.Entry nodeAttribute : nodeInfo.attributes().entrySet()) {
                            builder.field((String)nodeAttribute.getKey(), (String)nodeAttribute.getValue());
                        }
                        if (includeSettings) {
                            builder.startObject("settings");
                            Settings settings = RestNodesInfoAction.this.settingsFilter.filterSettings(nodeInfo.settings());
                            for (Map.Entry entry : settings.getAsMap().entrySet()) {
                                builder.field((String)entry.getKey(), (String)entry.getValue());
                            }
                            builder.endObject();
                        }
                        if (nodeInfo.os() != null) {
                            nodeInfo.os().toXContent(builder, request);
                        }
                        if (nodeInfo.process() != null) {
                            nodeInfo.process().toXContent(builder, request);
                        }
                        if (nodeInfo.jvm() != null) {
                            nodeInfo.jvm().toXContent(builder, request);
                        }
                        if (nodeInfo.network() != null) {
                            nodeInfo.network().toXContent(builder, request);
                        }
                        if (nodeInfo.transport() != null) {
                            nodeInfo.transport().toXContent(builder, request);
                        }
                        if (nodeInfo.http() != null) {
                            nodeInfo.http().toXContent(builder, request);
                        }
                        builder.endObject();
                    }
                    builder.endObject();
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestNodesInfoAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

