/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.search.nested.BlockJoinQuery;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetBinaryParseElement;
import org.elasticsearch.search.facet.FacetCollector;
import org.elasticsearch.search.facet.FacetParseElement;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.facet.OptimizeGlobalFacetCollector;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.query.QueryPhaseExecutionException;

public class FacetPhase
implements SearchPhase {
    private final FacetParseElement facetParseElement;
    private final FacetBinaryParseElement facetBinaryParseElement;

    @Inject
    public FacetPhase(FacetParseElement facetParseElement, FacetBinaryParseElement facetBinaryParseElement) {
        this.facetParseElement = facetParseElement;
        this.facetBinaryParseElement = facetBinaryParseElement;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("facets", this.facetParseElement, "facets_binary", this.facetBinaryParseElement, "facetsBinary", this.facetBinaryParseElement);
    }

    @Override
    public void preProcess(SearchContext context) {
        if (context.nestedQueries() != null) {
            for (Map.Entry<String, BlockJoinQuery> entry : context.nestedQueries().entrySet()) {
                List<Collector> collectors = context.searcher().removeCollectors(entry.getKey());
                if (collectors == null || collectors.isEmpty()) continue;
                if (collectors.size() == 1) {
                    entry.getValue().setCollector(collectors.get(0));
                    continue;
                }
                entry.getValue().setCollector(MultiCollector.wrap((Collector[])collectors.toArray(new Collector[collectors.size()])));
            }
        }
    }

    @Override
    public void execute(SearchContext context) throws ElasticSearchException {
        if (context.facets() == null || context.facets().facetCollectors() == null) {
            return;
        }
        if (context.queryResult().facets() != null) {
            return;
        }
        List<Collector> collectors = context.searcher().removeCollectors("_global_");
        if (collectors != null && !collectors.isEmpty()) {
            Filter filter;
            HashMap filtersByCollector = Maps.newHashMap();
            for (Collector collector : collectors) {
                ArrayList<Collector> list;
                AbstractFacetCollector facetCollector;
                if (collector instanceof OptimizeGlobalFacetCollector) {
                    try {
                        ((OptimizeGlobalFacetCollector)collector).optimizedGlobalExecution(context);
                        continue;
                    }
                    catch (IOException e) {
                        throw new QueryPhaseExecutionException(context, "Failed to execute global facets", (Throwable)e);
                    }
                }
                filter = Queries.MATCH_ALL_FILTER;
                if (collector instanceof AbstractFacetCollector && (facetCollector = (AbstractFacetCollector)collector).getFilter() != null) {
                    filter = facetCollector.getFilter();
                }
                if ((list = (ArrayList<Collector>)filtersByCollector.get(filter)) == null) {
                    list = new ArrayList<Collector>();
                    filtersByCollector.put(filter, list);
                }
                list.add(collector);
            }
            for (Map.Entry entry : filtersByCollector.entrySet()) {
                filter = (Filter)entry.getKey();
                DeletionAwareConstantScoreQuery query = new DeletionAwareConstantScoreQuery(filter);
                Filter searchFilter = context.mapperService().searchFilter(context.types());
                if (searchFilter != null) {
                    query = new FilteredQuery((Query)query, context.filterCache().cache(searchFilter));
                }
                try {
                    context.searcher().search((Query)query, MultiCollector.wrap((Collector[])((List)entry.getValue()).toArray(new Collector[((List)entry.getValue()).size()])));
                }
                catch (IOException e) {
                    throw new QueryPhaseExecutionException(context, "Failed to execute global facets", (Throwable)e);
                }
            }
        }
        SearchContextFacets contextFacets = context.facets();
        ArrayList<Facet> facets = Lists.newArrayListWithCapacity(2);
        if (contextFacets.facetCollectors() != null) {
            for (FacetCollector facetCollector : contextFacets.facetCollectors()) {
                facets.add(facetCollector.facet());
            }
        }
        context.queryResult().facets(new InternalFacets(facets));
    }
}

