/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.geo.GeoPointFieldData;
import org.elasticsearch.index.mapper.geo.GeoPointFieldDataType;
import org.elasticsearch.index.search.geo.GeoDistance;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.InternalGeoDistanceFacet;
import org.elasticsearch.search.internal.SearchContext;

public class GeoDistanceFacetCollector
extends AbstractFacetCollector {
    protected final String indexFieldName;
    protected final double lat;
    protected final double lon;
    protected final DistanceUnit unit;
    protected final GeoDistance geoDistance;
    protected final FieldDataCache fieldDataCache;
    protected GeoPointFieldData fieldData;
    protected final GeoDistanceFacet.Entry[] entries;
    protected GeoPointFieldData.ValueInDocProc aggregator;

    public GeoDistanceFacetCollector(String facetName, String fieldName, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, GeoDistanceFacet.Entry[] entries, SearchContext context) {
        super(facetName);
        this.lat = lat;
        this.lon = lon;
        this.unit = unit;
        this.entries = entries;
        this.geoDistance = geoDistance;
        this.fieldDataCache = context.fieldDataCache();
        MapperService.SmartNameFieldMappers smartMappers = context.mapperService().smartName(fieldName);
        if (smartMappers == null || !smartMappers.hasMapper()) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldName + "]");
        }
        if (smartMappers.mapper().fieldDataType() != GeoPointFieldDataType.TYPE) {
            throw new FacetPhaseExecutionException(facetName, "field [" + fieldName + "] is not a geo_point field");
        }
        if (smartMappers.hasDocMapper()) {
            this.setFilter(context.filterCache().cache(smartMappers.docMapper().typeFilter()));
        }
        this.indexFieldName = smartMappers.mapper().names().indexName();
        this.aggregator = new Aggregator(lat, lon, geoDistance, unit, entries);
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        this.fieldData = (GeoPointFieldData)this.fieldDataCache.cache(GeoPointFieldDataType.TYPE, reader, this.indexFieldName);
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        for (GeoDistanceFacet.Entry entry : this.entries) {
            entry.foundInDoc = false;
        }
        this.fieldData.forEachValueInDoc(doc, this.aggregator);
    }

    @Override
    public Facet facet() {
        return new InternalGeoDistanceFacet(this.facetName, this.entries);
    }

    public static class Aggregator
    implements GeoPointFieldData.ValueInDocProc {
        protected final double lat;
        protected final double lon;
        private final GeoDistance geoDistance;
        private final DistanceUnit unit;
        private final GeoDistanceFacet.Entry[] entries;

        public Aggregator(double lat, double lon, GeoDistance geoDistance, DistanceUnit unit, GeoDistanceFacet.Entry[] entries) {
            this.lat = lat;
            this.lon = lon;
            this.geoDistance = geoDistance;
            this.unit = unit;
            this.entries = entries;
        }

        @Override
        public void onValue(int docId, double lat, double lon) {
            double distance = this.geoDistance.calculate(this.lat, this.lon, lat, lon, this.unit);
            for (GeoDistanceFacet.Entry entry : this.entries) {
                if (entry.foundInDoc || !(distance >= entry.getFrom()) || !(distance < entry.getTo())) continue;
                entry.foundInDoc = true;
                ++entry.count;
                ++entry.totalCount;
                entry.total += distance;
                if (distance < entry.min) {
                    entry.min = distance;
                }
                if (!(distance > entry.max)) continue;
                entry.max = distance;
            }
        }
    }
}

