/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.statistical;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.field.data.NumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.facet.AbstractFacetCollector;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.statistical.InternalStatisticalFacet;
import org.elasticsearch.search.internal.SearchContext;

public class StatisticalFieldsFacetCollector
extends AbstractFacetCollector {
    private final String[] indexFieldsNames;
    private final FieldDataCache fieldDataCache;
    private final FieldDataType[] fieldsDataType;
    private NumericFieldData[] fieldsData;
    private final StatsProc statsProc = new StatsProc();

    public StatisticalFieldsFacetCollector(String facetName, String[] fieldsNames, SearchContext context) {
        super(facetName);
        this.fieldDataCache = context.fieldDataCache();
        this.fieldsDataType = new FieldDataType[fieldsNames.length];
        this.fieldsData = new NumericFieldData[fieldsNames.length];
        this.indexFieldsNames = new String[fieldsNames.length];
        for (int i = 0; i < fieldsNames.length; ++i) {
            FieldMapper mapper = context.mapperService().smartNameFieldMapper(fieldsNames[i]);
            if (mapper == null) {
                throw new FacetPhaseExecutionException(facetName, "No mapping found for field [" + fieldsNames[i] + "]");
            }
            this.indexFieldsNames[i] = mapper.names().indexName();
            this.fieldsDataType[i] = mapper.fieldDataType();
        }
    }

    @Override
    protected void doCollect(int doc) throws IOException {
        for (NumericFieldData fieldData : this.fieldsData) {
            fieldData.forEachValueInDoc(doc, this.statsProc);
        }
    }

    @Override
    protected void doSetNextReader(IndexReader reader, int docBase) throws IOException {
        for (int i = 0; i < this.indexFieldsNames.length; ++i) {
            this.fieldsData[i] = (NumericFieldData)this.fieldDataCache.cache(this.fieldsDataType[i], reader, this.indexFieldsNames[i]);
        }
    }

    @Override
    public Facet facet() {
        return new InternalStatisticalFacet(this.facetName, this.statsProc.min(), this.statsProc.max(), this.statsProc.total(), this.statsProc.sumOfSquares(), this.statsProc.count());
    }

    public static class StatsProc
    implements NumericFieldData.MissingDoubleValueInDocProc {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double total = 0.0;
        double sumOfSquares = 0.0;
        long count;
        int missing;

        @Override
        public void onValue(int docId, double value) {
            if (value < this.min) {
                this.min = value;
            }
            if (value > this.max) {
                this.max = value;
            }
            this.sumOfSquares += value * value;
            this.total += value;
            ++this.count;
        }

        @Override
        public void onMissing(int docId) {
            ++this.missing;
        }

        public final double min() {
            return this.min;
        }

        public final double max() {
            return this.max;
        }

        public final double total() {
            return this.total;
        }

        public final long count() {
            return this.count;
        }

        public final double sumOfSquares() {
            return this.sumOfSquares;
        }
    }
}

