/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class HighlightField
implements Streamable {
    private String name;
    private String[] fragments;

    HighlightField() {
    }

    public HighlightField(String name, String[] fragments) {
        this.name = name;
        this.fragments = fragments;
    }

    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name();
    }

    public String[] fragments() {
        return this.fragments;
    }

    public String[] getFragments() {
        return this.fragments();
    }

    public String toString() {
        return "[" + this.name + "], fragments[" + Arrays.toString(this.fragments) + "]";
    }

    public static HighlightField readHighlightField(StreamInput in) throws IOException {
        HighlightField field = new HighlightField();
        field.readFrom(in);
        return field;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readUTF();
        if (in.readBoolean()) {
            int size = in.readVInt();
            if (size == 0) {
                this.fragments = Strings.EMPTY_ARRAY;
            } else {
                this.fragments = new String[size];
                for (int i = 0; i < size; ++i) {
                    this.fragments[i] = in.readUTF();
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.name);
        if (this.fragments == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.fragments.length);
            for (String fragment : this.fragments) {
                out.writeUTF(fragment);
            }
        }
    }
}

