/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.db.Model;
import play.modules.elasticsearch.ElasticSearchDeliveryMode;
import play.modules.elasticsearch.ElasticSearchIndexEvent;
import play.modules.elasticsearch.IndexEventHandler;
import play.modules.elasticsearch.adapter.ElasticSearchAdapter;
import play.modules.elasticsearch.mapping.MapperFactory;
import play.modules.elasticsearch.mapping.MappingUtil;
import play.modules.elasticsearch.mapping.ModelMapper;
import play.modules.elasticsearch.util.ExceptionUtil;
import play.modules.elasticsearch.util.ReflectionUtil;
import play.mvc.Router;

public class ElasticSearchPlugin
extends PlayPlugin {
    private static boolean started = false;
    private static Map<Class<?>, ModelMapper<?>> mappers = null;
    private static Set<Class<?>> indicesStarted = null;
    private static Client client = null;

    public static Client client() {
        return client;
    }

    private boolean isLocalMode() {
        try {
            String client = Play.configuration.getProperty("elasticsearch.client");
            Boolean local = Boolean.getBoolean(Play.configuration.getProperty("elasticsearch.local", "true"));
            if (client == null) {
                return true;
            }
            if (client.equalsIgnoreCase("false") || client.equalsIgnoreCase("true")) {
                return true;
            }
            return local;
        }
        catch (Exception e) {
            Logger.error((String)"Error! Starting in Local Model: %s", (Object[])new Object[]{ExceptionUtil.getStackTrace(e)});
            return true;
        }
    }

    public static String getHosts() {
        String s = Play.configuration.getProperty("elasticsearch.client");
        if (s == null) {
            return "";
        }
        return s;
    }

    public static ElasticSearchDeliveryMode getDeliveryMode() {
        String s = Play.configuration.getProperty("elasticsearch.delivery");
        if (s == null) {
            return ElasticSearchDeliveryMode.LOCAL;
        }
        return ElasticSearchDeliveryMode.valueOf(s.toUpperCase());
    }

    public void onApplicationStart() {
        mappers = new HashMap();
        indicesStarted = new HashSet();
        ReflectionUtil.clearCache();
        if (client != null || started) {
            Logger.debug((String)"Elastic Search Started Already!", (Object[])new Object[0]);
            return;
        }
        ImmutableSettings.Builder settings = ImmutableSettings.settingsBuilder();
        settings.put("client.transport.sniff", true);
        settings.build();
        if (this.isLocalMode()) {
            Logger.info((String)"Starting Elastic Search for Play! in Local Mode", (Object[])new Object[0]);
            NodeBuilder nb = NodeBuilder.nodeBuilder().settings((Settings.Builder)settings).local(true).client(false).data(true);
            Node node = nb.node();
            client = node.client();
        } else {
            Logger.info((String)"Connecting Play! to Elastic Search in Client Mode", (Object[])new Object[0]);
            TransportClient c = new TransportClient((Settings.Builder)settings);
            if (Play.configuration.getProperty("elasticsearch.client") == null) {
                throw new RuntimeException("Configuration required - elasticsearch.client when local model is disabled!");
            }
            String[] hosts = ElasticSearchPlugin.getHosts().trim().split(",");
            boolean done = false;
            for (String host : hosts) {
                String[] parts = host.split(":");
                if (parts.length != 2) {
                    throw new RuntimeException("Invalid Host: " + host);
                }
                Logger.info((String)"Transport Client - Host: %s Port: %s", (Object[])new Object[]{parts[0], parts[1]});
                c.addTransportAddress((TransportAddress)new InetSocketTransportAddress(parts[0], Integer.valueOf(parts[1]).intValue()));
                done = true;
            }
            if (!done) {
                throw new RuntimeException("No Hosts Provided for Elastic Search!");
            }
            client = c;
        }
        Router.addRoute((String)"GET", (String)"/es-admin", (String)"elasticsearch.ElasticSearchAdmin.index");
        if (client == null) {
            throw new RuntimeException("Elastic Search Client cannot be null - please check the configuration provided and the health of your Elastic Search instances.");
        }
    }

    public static <M> ModelMapper<M> getMapper(Class<M> clazz) {
        if (mappers.containsKey(clazz)) {
            return mappers.get(clazz);
        }
        ModelMapper<M> mapper = MapperFactory.getMapper(clazz);
        mappers.put(clazz, mapper);
        return mapper;
    }

    private static void startIndexIfNeeded(Class<Model> clazz) {
        if (!indicesStarted.contains(clazz)) {
            ModelMapper<Model> mapper = ElasticSearchPlugin.getMapper(clazz);
            Logger.info((String)"Start Index for Class: %s", (Object[])new Object[]{clazz});
            ElasticSearchAdapter.startIndex(ElasticSearchPlugin.client(), mapper);
            indicesStarted.add(clazz);
        }
    }

    private static boolean isInterestingEvent(String event) {
        return event.endsWith(".objectPersisted") || event.endsWith(".objectUpdated") || event.endsWith(".objectDeleted");
    }

    public void onEvent(String message, Object context) {
        Logger.info((String)"Received %s Event, Object: %s", (Object[])new Object[]{message, context});
        if (!ElasticSearchPlugin.isInterestingEvent(message)) {
            return;
        }
        Logger.debug((String)"Processing %s Event", (Object[])new Object[]{message});
        if (!MappingUtil.isSearchable(context.getClass())) {
            return;
        }
        Validate.isTrue((boolean)(context instanceof Model), (String)"Only play.db.Model subclasses can be indexed");
        Class<Model> clazz = context.getClass();
        ElasticSearchPlugin.startIndexIfNeeded(clazz);
        ElasticSearchIndexEvent event = null;
        if (message.endsWith(".objectPersisted") || message.endsWith(".objectUpdated")) {
            event = new ElasticSearchIndexEvent((Model)context, ElasticSearchIndexEvent.Type.INDEX);
        } else if (message.endsWith(".objectDeleted")) {
            event = new ElasticSearchIndexEvent((Model)context, ElasticSearchIndexEvent.Type.DELETE);
        }
        Logger.info((String)"Elastic Search Index Event: %s", (Object[])new Object[]{event});
        if (event != null) {
            ElasticSearchDeliveryMode deliveryMode = ElasticSearchPlugin.getDeliveryMode();
            IndexEventHandler handler = deliveryMode.getHandler();
            handler.handle(event);
        }
    }

    <M extends Model> void index(M model) {
        Class<Model> clazz = model.getClass();
        if (!MappingUtil.isSearchable(clazz)) {
            throw new IllegalArgumentException("model is not searchable");
        }
        ElasticSearchPlugin.startIndexIfNeeded(clazz);
        ElasticSearchIndexEvent event = new ElasticSearchIndexEvent(model, ElasticSearchIndexEvent.Type.INDEX);
        ElasticSearchDeliveryMode deliveryMode = ElasticSearchPlugin.getDeliveryMode();
        IndexEventHandler handler = deliveryMode.getHandler();
        handler.handle(event);
    }
}

