/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.adapter;

import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import play.Logger;
import play.db.Model;
import play.modules.elasticsearch.mapping.MappingUtil;
import play.modules.elasticsearch.mapping.ModelMapper;
import play.modules.elasticsearch.util.ExceptionUtil;

public abstract class ElasticSearchAdapter {
    public static <T extends Model> void startIndex(Client client, ModelMapper<T> mapper) {
        ElasticSearchAdapter.createIndex(client, mapper);
        ElasticSearchAdapter.createType(client, mapper);
    }

    private static void createIndex(Client client, ModelMapper<?> mapper) {
        String indexName = mapper.getIndexName();
        try {
            Logger.debug((String)"Starting Elastic Search Index %s", (Object[])new Object[]{indexName});
            CreateIndexResponse response = (CreateIndexResponse)client.admin().indices().create(new CreateIndexRequest(indexName)).actionGet();
            Logger.debug((String)"Response: %s", (Object[])new Object[]{response});
        }
        catch (IndexAlreadyExistsException iaee) {
            Logger.debug((String)"Index already exists: %s", (Object[])new Object[]{indexName});
        }
        catch (Throwable t) {
            Logger.warn((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
        }
    }

    private static void createType(Client client, ModelMapper<?> mapper) {
        String indexName = mapper.getIndexName();
        String typeName = mapper.getTypeName();
        try {
            Logger.debug((String)"Create Elastic Search Type %s/%s", (Object[])new Object[]{indexName, typeName});
            PutMappingRequest request = Requests.putMappingRequest((String[])new String[]{indexName}).type(typeName);
            XContentBuilder mapping = MappingUtil.getMapping(mapper);
            Logger.debug((String)"Type mapping: \n %s", (Object[])new Object[]{mapping.string()});
            request.source(mapping);
            PutMappingResponse response = (PutMappingResponse)client.admin().indices().putMapping(request).actionGet();
            Logger.debug((String)"Response: %s", (Object[])new Object[]{response});
        }
        catch (IndexAlreadyExistsException iaee) {
            Logger.debug((String)"Index already exists: %s", (Object[])new Object[]{indexName});
        }
        catch (Throwable t) {
            Logger.warn((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Model> void indexModel(Client client, ModelMapper<T> mapper, T model) throws Exception {
        Logger.debug((String)"Index Model: %s", (Object[])new Object[]{model});
        if (client == null) {
            Logger.error((String)"Elastic Search Client is null, aborting", (Object[])new Object[0]);
            return;
        }
        XContentBuilder contentBuilder = null;
        try {
            String indexName = mapper.getIndexName();
            String typeName = mapper.getTypeName();
            String documentId = mapper.getDocumentId(model);
            Logger.debug((String)"Index Name: %s", (Object[])new Object[]{indexName});
            contentBuilder = XContentFactory.jsonBuilder().prettyPrint();
            mapper.addModel(model, contentBuilder);
            Logger.debug((String)"Index json: %s", (Object[])new Object[]{contentBuilder.string()});
            IndexResponse response = (IndexResponse)client.prepareIndex(indexName, typeName, documentId).setSource(contentBuilder).execute().actionGet();
            Logger.info((String)"Index Response: %s", (Object[])new Object[]{response});
        }
        finally {
            if (contentBuilder != null) {
                contentBuilder.close();
            }
        }
    }

    public static <T extends Model> void deleteModel(Client client, ModelMapper<T> mapper, T model) throws Exception {
        Logger.debug((String)"Delete Model: %s", (Object[])new Object[]{model});
        String indexName = mapper.getIndexName();
        String typeName = mapper.getTypeName();
        String documentId = mapper.getDocumentId(model);
        DeleteResponse response = (DeleteResponse)client.prepareDelete(indexName, typeName, documentId).setOperationThreaded(false).execute().actionGet();
        Logger.debug((String)"Delete Response: %s", (Object[])new Object[]{response});
    }
}

