/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping;

import java.lang.reflect.Field;
import java.util.Collection;
import play.db.Model;
import play.modules.elasticsearch.annotations.ElasticSearchEmbedded;
import play.modules.elasticsearch.mapping.FieldMapper;
import play.modules.elasticsearch.mapping.MappingException;
import play.modules.elasticsearch.mapping.MappingUtil;
import play.modules.elasticsearch.mapping.ModelMapper;
import play.modules.elasticsearch.mapping.impl.CollectionFieldMapper;
import play.modules.elasticsearch.mapping.impl.EmbeddedFieldMapper;
import play.modules.elasticsearch.mapping.impl.PlayModelMapper;
import play.modules.elasticsearch.mapping.impl.SimpleFieldMapper;

public class MapperFactory {
    public static <M> ModelMapper<M> getMapper(Class<M> clazz) throws MappingException {
        if (!MappingUtil.isSearchable(clazz)) {
            throw new MappingException("Class must be annotated with @ElasticSearchable");
        }
        if (Model.class.isAssignableFrom(clazz)) {
            return new PlayModelMapper<M>(clazz);
        }
        throw new MappingException("No mapper available for non-play.db.Model models at this time");
    }

    public static <M> FieldMapper<M> getMapper(Field field) throws MappingException {
        return MapperFactory.getMapper(field, null);
    }

    public static <M> FieldMapper<M> getMapper(Field field, String prefix) throws MappingException {
        if (Collection.class.isAssignableFrom(field.getType())) {
            return new CollectionFieldMapper(field, prefix);
        }
        if (field.isAnnotationPresent(ElasticSearchEmbedded.class)) {
            return new EmbeddedFieldMapper(field, prefix);
        }
        return new SimpleFieldMapper(field, prefix);
    }
}

