/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang.Validate;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import play.Logger;
import play.modules.elasticsearch.annotations.ElasticSearchField;
import play.modules.elasticsearch.mapping.ModelMapper;
import play.modules.elasticsearch.util.ExceptionUtil;

public abstract class MappingUtil {
    private MappingUtil() {
    }

    public static boolean isSearchable(Class<?> clazz) {
        while (clazz != null) {
            for (Annotation a : clazz.getAnnotations()) {
                if (((Object)a).toString().indexOf("ElasticSearchable") <= -1) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static XContentBuilder getMapping(ModelMapper<?> mapper) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        mapper.addMapping(builder);
        builder.endObject();
        return builder;
    }

    public static void addField(XContentBuilder builder, String name, String type, ElasticSearchField meta) throws IOException {
        Validate.notEmpty((String)name, (String)"name cannot be empty");
        Validate.notEmpty((String)type, (String)"type cannot be empty");
        builder.startObject(name);
        builder.field("type", type);
        if (meta != null) {
            if (meta.index() != ElasticSearchField.Index.NOT_SET) {
                builder.field("index", meta.index().toString());
            }
            if (meta.store() != ElasticSearchField.Store.NOT_SET) {
                builder.field("store", meta.store().toString());
            }
        }
        builder.endObject();
    }

    public static String detectFieldType(Class<?> clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return "string";
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return "integer";
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            return "short";
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return "long";
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return "float";
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return "double";
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            return "byte";
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return "date";
        }
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return "boolean";
        }
        return "string";
    }

    public static Object convertValue(Object value, Class<?> targetType) {
        if (targetType.equals(value.getClass())) {
            return value;
        }
        if (targetType.equals(String.class)) {
            return value.toString();
        }
        if (targetType.equals(BigDecimal.class)) {
            return new BigDecimal(value.toString());
        }
        if (targetType.equals(Date.class)) {
            return MappingUtil.convertToDate(value);
        }
        if (targetType.equals(Integer.class)) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.valueOf(value.toString());
        }
        if (targetType.equals(Long.class)) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.valueOf(value.toString());
        }
        if (targetType.equals(Double.class)) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.valueOf(value.toString());
        }
        if (targetType.equals(Float.class)) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(value.toString());
        }
        return value;
    }

    private static Date convertToDate(Object value) {
        Date date = null;
        if (value != null && !"".equals(value)) {
            if (value instanceof Long) {
                date = new Date((Long)value);
            } else if (value instanceof String) {
                String val = (String)value;
                int dateLength = String.valueOf(Long.MAX_VALUE).length();
                date = dateLength == val.length() ? new Date(Long.valueOf(val)) : MappingUtil.getDate(val);
            } else {
                date = (Date)value;
            }
        }
        return date;
    }

    private static Date getDate(String val) {
        try {
            return XContentBuilder.defaultDatePrinter.parseDateTime(val).toDate();
        }
        catch (Throwable t) {
            Logger.error((String)ExceptionUtil.getStackTrace(t), (Object[])new Object[]{val});
            return null;
        }
    }
}

