/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping.impl;

import java.lang.reflect.Field;
import org.apache.commons.lang.Validate;
import play.modules.elasticsearch.annotations.ElasticSearchField;
import play.modules.elasticsearch.mapping.FieldMapper;
import play.modules.elasticsearch.mapping.MappingUtil;
import play.modules.elasticsearch.util.ReflectionUtil;

public abstract class AbstractFieldMapper<M>
implements FieldMapper<M> {
    protected final Field field;
    protected final ElasticSearchField meta;
    private final String prefix;
    private final String indexField;

    public AbstractFieldMapper(Field field, String prefix) {
        Validate.notNull((Object)field, (String)"field cannot be null");
        this.field = field;
        this.meta = field.getAnnotation(ElasticSearchField.class);
        this.prefix = prefix;
        this.indexField = this.prefix(field.getName());
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected String prefix(String value) {
        if (this.prefix != null) {
            return this.prefix + value;
        }
        return value;
    }

    protected String getFieldName() {
        return this.field.getName();
    }

    protected Class<?> getFieldType() {
        return this.field.getType();
    }

    protected String getIndexField() {
        return this.indexField;
    }

    protected String getIndexType() {
        if (this.meta != null && this.meta.type().length() > 0) {
            return this.meta.type();
        }
        return MappingUtil.detectFieldType(this.field.getType());
    }

    protected Object getFieldValue(M model) {
        return ReflectionUtil.getFieldValue(model, this.field);
    }
}

