/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentBuilder;
import play.modules.elasticsearch.annotations.ElasticSearchEmbedded;
import play.modules.elasticsearch.mapping.FieldMapper;
import play.modules.elasticsearch.mapping.MapperFactory;
import play.modules.elasticsearch.mapping.MappingException;
import play.modules.elasticsearch.mapping.MappingUtil;
import play.modules.elasticsearch.mapping.impl.AbstractFieldMapper;
import play.modules.elasticsearch.mapping.impl.EmbeddedFieldMapper;
import play.modules.elasticsearch.util.ReflectionUtil;

public class CollectionFieldMapper<M>
extends AbstractFieldMapper<M> {
    private final boolean nestedMode;
    private final String type;
    private final List<FieldMapper<Object>> fields;

    public CollectionFieldMapper(Field field, String prefix) {
        super(field, prefix);
        if (!Collection.class.isAssignableFrom(field.getType())) {
            throw new MappingException("field must be of Collection type");
        }
        ElasticSearchEmbedded embed = field.getAnnotation(ElasticSearchEmbedded.class);
        this.nestedMode = embed != null;
        this.type = MappingUtil.detectFieldType(this.getCollectionType());
        if (this.nestedMode) {
            Class<?> itemClass = this.getCollectionType();
            List<Field> fieldsToIndex = EmbeddedFieldMapper.getFieldsToIndex(itemClass, embed);
            this.fields = new ArrayList<FieldMapper<Object>>();
            for (Field embeddedField : fieldsToIndex) {
                this.fields.add(MapperFactory.getMapper(embeddedField));
            }
        } else {
            this.fields = null;
        }
    }

    private Class<?> getCollectionType() {
        ParameterizedType type = (ParameterizedType)this.field.getGenericType();
        return (Class)type.getActualTypeArguments()[0];
    }

    @Override
    public void addToMapping(XContentBuilder builder) throws IOException {
        String indexFieldName = this.getIndexField();
        if (this.nestedMode) {
            builder.startObject(indexFieldName);
            builder.startObject("properties");
            for (FieldMapper<Object> mapper : this.fields) {
                mapper.addToMapping(builder);
            }
            builder.endObject();
            builder.endObject();
        } else {
            MappingUtil.addField(builder, indexFieldName, this.type, this.meta);
        }
    }

    @Override
    public void addToDocument(M model, XContentBuilder builder) throws IOException {
        String indexFieldName = this.getIndexField();
        Collection value = (Collection)this.getFieldValue(model);
        if (value != null) {
            builder.startArray(indexFieldName);
            if (this.nestedMode) {
                for (Object object : value) {
                    builder.startObject();
                    for (FieldMapper<Object> mapper : this.fields) {
                        mapper.addToDocument(object, builder);
                    }
                    builder.endObject();
                }
            } else {
                boolean isStringType = this.type.equals("string");
                for (Object object : value) {
                    if (isStringType) {
                        builder.value(object.toString());
                        continue;
                    }
                    builder.value(object);
                }
            }
            builder.endArray();
        }
    }

    @Override
    public boolean inflate(M model, Map<String, Object> map) {
        String indexFieldName = this.getIndexField();
        List indexValue = (List)map.get(indexFieldName);
        Collection modelValue = (Collection)this.getFieldValue(model);
        Class<?> type = this.getCollectionType();
        if (indexValue != null && modelValue != null) {
            if (this.nestedMode) {
                for (Object indexItem : indexValue) {
                    Map indexItemMap = (Map)indexItem;
                    Object outputItem = ReflectionUtil.newInstance(type);
                    for (FieldMapper<Object> mapper : this.fields) {
                        mapper.inflate(outputItem, indexItemMap);
                    }
                    modelValue.add(outputItem);
                }
            } else {
                for (Object indexItem : indexValue) {
                    Object modelItem = MappingUtil.convertValue(indexItem, type);
                    if (!type.isAssignableFrom(modelItem.getClass())) continue;
                    modelValue.add(modelItem);
                }
            }
            return true;
        }
        return false;
    }
}

