/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentBuilder;
import play.modules.elasticsearch.annotations.ElasticSearchEmbedded;
import play.modules.elasticsearch.mapping.FieldMapper;
import play.modules.elasticsearch.mapping.MapperFactory;
import play.modules.elasticsearch.mapping.MappingException;
import play.modules.elasticsearch.mapping.impl.AbstractFieldMapper;
import play.modules.elasticsearch.mapping.impl.PlayModelMapper;
import play.modules.elasticsearch.util.ReflectionUtil;
import scala.actors.threadpool.Arrays;

public class EmbeddedFieldMapper<M>
extends AbstractFieldMapper<M> {
    private final ElasticSearchEmbedded embed;
    private final List<FieldMapper<Object>> fields;

    public EmbeddedFieldMapper(Field field, String prefix) {
        super(field, prefix);
        this.embed = field.getAnnotation(ElasticSearchEmbedded.class);
        String embedPrefix = null;
        if (this.embed.mode() == ElasticSearchEmbedded.Mode.embedded) {
            embedPrefix = this.embed.prefix().length() > 0 ? this.prefix(this.embed.prefix()) : this.getFieldName() + ".";
        }
        this.fields = new ArrayList<FieldMapper<Object>>();
        for (Field embeddedField : EmbeddedFieldMapper.getFieldsToIndex(field.getType(), this.embed)) {
            this.fields.add(MapperFactory.getMapper(embeddedField, embedPrefix));
        }
    }

    static List<Field> getFieldsToIndex(Class<?> clazz, ElasticSearchEmbedded meta) {
        List fieldsToIndex = Arrays.asList((Object[])meta.fields());
        List<Field> clazzFields = ReflectionUtil.getAllFields(clazz);
        ArrayList<Field> fields = new ArrayList<Field>();
        if (fieldsToIndex.size() > 0) {
            for (String fieldName : fieldsToIndex) {
                boolean knownField = false;
                for (Field clazzField : clazzFields) {
                    if (!clazzField.getName().equals(fieldName)) continue;
                    knownField = true;
                    break;
                }
                if (knownField) continue;
                throw new MappingException("Unknown field specified in " + meta);
            }
        }
        for (Field embeddedField : clazzFields) {
            if (PlayModelMapper.shouldIgnoreField(embeddedField) || fieldsToIndex.size() == 0 && PlayModelMapper.userRequestedIgnoreField(embeddedField) || fieldsToIndex.size() > 0 && !fieldsToIndex.contains(embeddedField.getName())) continue;
            fields.add(embeddedField);
        }
        return fields;
    }

    @Override
    public void addToMapping(XContentBuilder builder) throws IOException {
        String indexFieldName = this.getIndexField();
        switch (this.embed.mode()) {
            case embedded: {
                for (FieldMapper<Object> mapper : this.fields) {
                    mapper.addToMapping(builder);
                }
                break;
            }
            case object: 
            case nested: {
                builder.startObject(indexFieldName);
                builder.field("type", this.embed.mode().toString());
                builder.startObject("properties");
                for (FieldMapper<Object> mapper : this.fields) {
                    mapper.addToMapping(builder);
                }
                builder.endObject();
                builder.endObject();
            }
        }
    }

    @Override
    public void addToDocument(M model, XContentBuilder builder) throws IOException {
        String name = this.getIndexField();
        Object value = this.getFieldValue(model);
        if (value != null) {
            switch (this.embed.mode()) {
                case embedded: {
                    for (FieldMapper<Object> mapper : this.fields) {
                        mapper.addToDocument(value, builder);
                    }
                    break;
                }
                case object: 
                case nested: {
                    builder.startObject(name);
                    for (FieldMapper<Object> mapper : this.fields) {
                        mapper.addToDocument(value, builder);
                    }
                    builder.endObject();
                }
            }
        }
    }

    @Override
    public boolean inflate(M model, Map<String, Object> map) {
        String name = this.getFieldName();
        Object value = ReflectionUtil.newInstance(this.getFieldType());
        boolean nonNullValue = false;
        switch (this.embed.mode()) {
            case embedded: {
                for (FieldMapper<Object> mapper : this.fields) {
                    if (!mapper.inflate(value, map)) continue;
                    nonNullValue = true;
                }
                break;
            }
            case object: 
            case nested: {
                Object input = map.get(name);
                if (input == null) break;
                Map nestedMap = (Map)input;
                for (FieldMapper<Object> mapper : this.fields) {
                    mapper.inflate(value, nestedMap);
                }
                nonNullValue = true;
            }
        }
        if (nonNullValue) {
            ReflectionUtil.setFieldValue(model, name, value);
            return true;
        }
        return false;
    }
}

