/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.mapping.impl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Map;
import org.elasticsearch.common.xcontent.XContentBuilder;
import play.modules.elasticsearch.mapping.MappingUtil;
import play.modules.elasticsearch.mapping.impl.AbstractFieldMapper;
import play.modules.elasticsearch.util.ReflectionUtil;

public class SimpleFieldMapper<M>
extends AbstractFieldMapper<M> {
    public SimpleFieldMapper(Field field, String prefix) {
        super(field, prefix);
    }

    @Override
    public void addToMapping(XContentBuilder builder) throws IOException {
        String field = this.getIndexField();
        String type = this.getIndexType();
        MappingUtil.addField(builder, field, type, this.meta);
    }

    @Override
    public void addToDocument(M model, XContentBuilder builder) throws IOException {
        String field = this.getIndexField();
        Object value = this.getFieldValue(model);
        if (value != null) {
            builder.field(field, value);
        }
    }

    @Override
    public boolean inflate(M model, Map<String, Object> map) {
        Object value;
        String modelFieldName = this.getFieldName();
        String indexFieldName = this.getIndexField();
        if (map.containsKey(indexFieldName) && (value = map.get(indexFieldName)) != null) {
            ReflectionUtil.setFieldValue(model, modelFieldName, value);
            return true;
        }
        return false;
    }
}

