/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.transformer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import play.Logger;
import play.data.binding.Binder;
import play.db.Model;
import play.db.jpa.JPQL;
import play.exceptions.UnexpectedException;
import play.modules.elasticsearch.search.SearchResults;
import play.modules.elasticsearch.transformer.Transformer;

public class JPATransformer<T extends Model>
implements Transformer<T> {
    @Override
    public SearchResults<T> toSearchResults(SearchResponse searchResponse, Class<T> clazz) {
        long count = searchResponse.hits().totalHits();
        Model.Factory factory = Model.Manager.factoryFor(clazz);
        Class keyType = factory.keyType();
        ArrayList<Object> ids = new ArrayList<Object>();
        for (SearchHit h : searchResponse.hits()) {
            try {
                ids.add(Binder.directBind((String)h.getId(), (Class)keyType));
            }
            catch (Exception e) {
                throw new UnexpectedException("Could not convert the ID from index to corresponding type", (Throwable)e);
            }
        }
        Logger.debug((String)"Model IDs returned by ES: %s", (Object[])new Object[]{ids});
        List objects = null;
        if (ids.size() > 0) {
            objects = JPATransformer.loadFromDb(clazz, ids);
            JPATransformer.sortByIds(objects, ids);
            if (objects.size() != ids.size()) {
                throw new IllegalStateException("Please re-index, not all indexed items are available in the database");
            }
        } else {
            objects = Collections.emptyList();
        }
        Logger.debug((String)"Models after sorting: %s", (Object[])new Object[]{objects});
        return new SearchResults(count, objects, searchResponse.facets());
    }

    private static <T extends Model> List<T> loadFromDb(Class<T> clazz, List<Object> ids) {
        List objects = JPQL.instance.find(clazz.getName(), "id in (?1)", new Object[]{ids}).fetch();
        return objects;
    }

    private static <T extends Model> void sortByIds(List<T> objects, final List<Object> ids) {
        Collections.sort(objects, new Comparator<T>(){

            @Override
            public int compare(T arg0, T arg1) {
                Integer idx1 = ids.indexOf(arg0._key());
                Integer idx2 = ids.indexOf(arg1._key());
                return idx1.compareTo(idx2);
            }
        });
    }
}

