/*
 * Decompiled with CFR 0.152.
 */
package play.modules.elasticsearch.transformer;

import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import play.Logger;
import play.db.Model;
import play.modules.elasticsearch.ElasticSearchPlugin;
import play.modules.elasticsearch.mapping.ModelMapper;
import play.modules.elasticsearch.search.SearchResults;
import play.modules.elasticsearch.transformer.Transformer;

public class MapperTransformer<T extends Model>
implements Transformer<T> {
    @Override
    public SearchResults<T> toSearchResults(SearchResponse searchResponse, Class<T> clazz) {
        long count = searchResponse.hits().totalHits();
        ArrayList<Model> objects = new ArrayList<Model>();
        ModelMapper<T> mapper = ElasticSearchPlugin.getMapper(clazz);
        for (SearchHit h : searchResponse.hits()) {
            Map map = h.sourceAsMap();
            Logger.debug((String)"Record Map: %s", (Object[])new Object[]{map});
            Model o = (Model)mapper.createModel(map);
            Logger.debug((String)"Model Instance: %s", (Object[])new Object[]{o});
            objects.add(o);
        }
        return new SearchResults(count, objects, searchResponse.facets());
    }
}

