/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.hssf.record.formula.functions.LookupUtils;

public final class Vlookup
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        Eval arg3 = null;
        switch (args.length) {
            case 4: {
                arg3 = args[3];
            }
            case 3: {
                break;
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        try {
            ValueEval lookupValue = OperandResolver.getSingleValue(args[0], srcCellRow, srcCellCol);
            AreaEval tableArray = LookupUtils.resolveTableArrayArg(args[1]);
            boolean isRangeLookup = LookupUtils.resolveRangeLookupArg(arg3, srcCellRow, srcCellCol);
            int rowIndex = LookupUtils.lookupIndexOfValue(lookupValue, LookupUtils.createColumnVector(tableArray, 0), isRangeLookup);
            int colIndex = LookupUtils.resolveRowOrColIndexArg(args[2], srcCellRow, srcCellCol);
            LookupUtils.ValueVector resultCol = this.createResultColumnVector(tableArray, colIndex);
            return resultCol.getItem(rowIndex);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }

    private LookupUtils.ValueVector createResultColumnVector(AreaEval tableArray, int colIndex) throws EvaluationException {
        if (colIndex >= tableArray.getWidth()) {
            throw EvaluationException.invalidRef();
        }
        return LookupUtils.createColumnVector(tableArray, colIndex);
    }
}

