/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.util.HashMap;
import java.util.Map;
import net.sf.jxls.formula.ListRange;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.Workbook;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class Sheet {
    Workbook workbook;
    HSSFWorkbook hssfWorkbook;
    HSSFSheet hssfSheet;
    private Map listRanges = new HashMap();
    private Map namedCells = new HashMap();
    Configuration configuration = new Configuration();
    String sheetName;

    public Sheet() {
    }

    public Sheet(HSSFWorkbook hssfWorkbook, HSSFSheet hssfSheet, Configuration configuration) {
        this.hssfWorkbook = hssfWorkbook;
        this.hssfSheet = hssfSheet;
        this.configuration = configuration;
    }

    public Sheet(HSSFWorkbook hssfWorkbook, HSSFSheet hssfSheet) {
        this.hssfWorkbook = hssfWorkbook;
        this.hssfSheet = hssfSheet;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void initSheetName() {
        for (int i = 0; i < this.hssfWorkbook.getNumberOfSheets(); ++i) {
            HSSFSheet sheet = this.hssfWorkbook.getSheetAt(i);
            if (sheet != this.hssfSheet) continue;
            this.sheetName = this.hssfWorkbook.getSheetName(i);
            if (this.sheetName.indexOf(32) < 0) continue;
            this.sheetName = "'" + this.sheetName + "'";
        }
    }

    public HSSFWorkbook getHssfWorkbook() {
        return this.hssfWorkbook;
    }

    public void setHssfWorkbook(HSSFWorkbook hssfWorkbook) {
        this.hssfWorkbook = hssfWorkbook;
    }

    public void setHssfSheet(HSSFSheet hssfSheet) {
        this.hssfSheet = hssfSheet;
    }

    public HSSFSheet getHssfSheet() {
        return this.hssfSheet;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Map getListRanges() {
        return this.listRanges;
    }

    public Map getNamedCells() {
        return this.namedCells;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public void addNamedCell(String label, Cell cell) {
        this.namedCells.put(label, cell);
    }

    public void addListRange(String name, ListRange range) {
        this.listRanges.put(name, range);
    }

    public int getMaxColNum() {
        short maxColNum = 0;
        for (int i = this.hssfSheet.getFirstRowNum(); i <= this.hssfSheet.getLastRowNum(); ++i) {
            HSSFRow hssfRow = this.hssfSheet.getRow(i);
            if (hssfRow == null || hssfRow.getLastCellNum() <= maxColNum) continue;
            maxColNum = hssfRow.getLastCellNum();
        }
        return maxColNum;
    }
}

