/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.util;

import java.util.List;
import java.util.Map;
import net.sf.jxls.formula.Formula;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class FormulaUtil {
    public static void updateFormulas(HSSFSheet sheet, List formulas, Map listRanges, Map namedCells, boolean ignoreUnresolved) {
        for (int i = 0; i < formulas.size(); ++i) {
            Formula formula = (Formula)formulas.get(i);
            String formulaString = formula.getAppliedFormula(listRanges, namedCells);
            HSSFRow hssfRow = sheet.getRow(formula.getRowNum().intValue());
            HSSFCell hssfCell = hssfRow.getCell(formula.getCellNum().shortValue());
            if (formulaString != null) {
                hssfCell.setCellFormula(formulaString);
                continue;
            }
            if (ignoreUnresolved) continue;
            hssfCell.setCellValue(new HSSFRichTextString(""));
            formulas.remove(i--);
        }
    }

    static boolean formulaExists(List formulas, Formula formula) {
        for (int i = 0; i < formulas.size(); ++i) {
            Formula cur = (Formula)formulas.get(i);
            if (!cur.getFormula().equals(formula.getFormula())) continue;
            return true;
        }
        return false;
    }
}

