/*
 * Decompiled with CFR 0.152.
 */
package play.modules.excel;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.commons.codec.net.URLCodec;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import play.Play;
import play.exceptions.UnexpectedException;
import play.mvc.Http;
import play.mvc.results.Result;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderExcelTemplate
extends Result {
    private static final long serialVersionUID = 8823129782155149907L;
    private static URLCodec encoder = new URLCodec();
    private static VirtualFile tmplRoot = null;
    String templateName = null;
    String fileName = null;
    boolean inline = true;
    Map<String, Object> beans = null;

    private static void initTmplRoot() {
        VirtualFile appRoot = VirtualFile.open((File)Play.applicationPath);
        String rootDef = "app/views";
        if (Play.configuration.containsKey("excel.template.root")) {
            rootDef = (String)Play.configuration.get("excel.template.root");
        }
        tmplRoot = appRoot.child(rootDef);
    }

    public RenderExcelTemplate(String templateName, Map<String, Object> beans) {
        this(templateName, beans, null);
    }

    public RenderExcelTemplate(String templateName, Map<String, Object> beans, String fileName) {
        this(templateName, beans, fileName, false);
    }

    public RenderExcelTemplate(String templateName, Map<String, Object> beans, String fileName, boolean inline) {
        this.templateName = templateName;
        this.fileName = fileName;
        this.inline = inline;
        this.beans = beans;
    }

    public void apply(Http.Request request, Http.Response response) {
        try {
            if (!response.headers.containsKey("Content-Disposition")) {
                if (this.inline) {
                    if (this.fileName == null) {
                        response.setHeader("Content-Disposition", "inline");
                    } else {
                        response.setHeader("Content-Disposition", "inline; filename=" + encoder.encode(this.fileName, "utf-8"));
                    }
                } else if (this.fileName == null) {
                    response.setHeader("Content-Disposition", "attachment; filename=export.xls");
                } else {
                    response.setHeader("Content-Disposition", "attachment; filename=" + encoder.encode(this.fileName, "utf-8"));
                }
            }
            this.setContentTypeIfNotSet(response, "application/vnd.ms-excel");
            if (null == tmplRoot) {
                RenderExcelTemplate.initTmplRoot();
            }
            InputStream is = tmplRoot.child(this.templateName).inputstream();
            HSSFWorkbook workbook = new XLSTransformer().transformXLS(is, this.beans);
            workbook.write((OutputStream)response.out);
            is.close();
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

