/*
 * Decompiled with CFR 0.152.
 */
package play.modules.excel;

import java.util.List;
import play.Play;
import play.classloading.enhancers.LocalvariablesNamesEnhancer;
import play.data.validation.Validation;
import play.exceptions.PlayException;
import play.exceptions.TemplateNotFoundException;
import play.exceptions.UnexpectedException;
import play.modules.excel.RenderExcelTemplate;
import play.mvc.Http;
import play.mvc.Scope;

public class Excel {
    public static void renderTemplateAsExcel(String templateName, Object ... args) {
        Scope.RenderArgs templateBinding = Scope.RenderArgs.current();
        for (Object o : args) {
            List names = LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.getAllLocalVariableNames((Object)o);
            for (String name : names) {
                templateBinding.put(name, o);
            }
        }
        templateBinding.put("session", (Object)Scope.Session.current());
        templateBinding.put("request", (Object)Http.Request.current());
        templateBinding.put("flash", (Object)Scope.Flash.current());
        templateBinding.put("params", (Object)Scope.Params.current());
        if (null == templateBinding.get("fileName")) {
            templateBinding.put("fileName", (Object)(templateName.substring(templateName.lastIndexOf("/") + 1) + ".xls"));
        }
        try {
            templateBinding.put("errors", (Object)Validation.errors());
        }
        catch (Exception ex) {
            throw new UnexpectedException((Throwable)ex);
        }
        try {
            throw new RenderExcelTemplate(templateName + ".xls", templateBinding.data, templateBinding.get("fileName").toString());
        }
        catch (TemplateNotFoundException ex) {
            if (ex.isSourceAvailable()) {
                throw ex;
            }
            StackTraceElement element = PlayException.getInterestingStrackTraceElement((Throwable)ex);
            if (element != null) {
                throw new TemplateNotFoundException(templateName, Play.classes.getApplicationClass(element.getClassName()), Integer.valueOf(element.getLineNumber()));
            }
            throw ex;
        }
    }

    public static void renderExcel(Object ... args) {
        String templateName = null;
        Http.Request request = Http.Request.current();
        templateName = args.length > 0 && args[0] instanceof String && LocalvariablesNamesEnhancer.LocalVariablesNamesTracer.getAllLocalVariableNames((Object)args[0]).isEmpty() ? args[0].toString() : request.action.replace(".", "/");
        if (templateName.startsWith("@")) {
            if (!(templateName = templateName.substring(1)).contains(".")) {
                templateName = request.controller + "." + templateName;
            }
            templateName = templateName.replace(".", "/");
        }
        Excel.renderTemplateAsExcel(templateName, args);
    }
}

