/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.jxls.reader.OffsetCellCheck;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class OffsetCellCheckImpl
implements OffsetCellCheck {
    Object value;
    short offset;

    public OffsetCellCheckImpl() {
    }

    public OffsetCellCheckImpl(short offset, Object value) {
        this.offset = offset;
        this.value = value;
    }

    public OffsetCellCheckImpl(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public short getOffset() {
        return this.offset;
    }

    public void setOffset(short offset) {
        this.offset = offset;
    }

    public boolean isCheckSuccessful(Cell cell) {
        Object obj = this.getCellValue(cell, this.value);
        if (this.value == null) {
            return obj == null;
        }
        return this.value.equals(obj);
    }

    public boolean isCheckSuccessful(Row row) {
        if (row == null) {
            return this.value == null;
        }
        Cell cell = row.getCell((int)this.offset);
        return this.isCheckSuccessful(cell);
    }

    private Object getCellValue(Cell cell, Object obj) {
        Object value = null;
        if (obj instanceof String) {
            value = this.readStringValue(cell);
        } else if (obj instanceof Double) {
            value = new Double(cell.getNumericCellValue());
        } else if (obj instanceof BigDecimal) {
            value = new BigDecimal(cell.getNumericCellValue());
        } else if (obj instanceof Integer) {
            value = new Integer((int)cell.getNumericCellValue());
        } else if (obj instanceof Float) {
            value = new Float(cell.getNumericCellValue());
        } else if (obj instanceof Date) {
            value = cell.getDateCellValue();
        } else if (obj instanceof Calendar) {
            Calendar c = Calendar.getInstance();
            c.setTime(cell.getDateCellValue());
            value = c;
        } else if (obj instanceof Boolean) {
            value = cell.getCellType() == 4 ? (cell.getBooleanCellValue() ? Boolean.TRUE : Boolean.FALSE) : (cell.getCellType() == 1 ? Boolean.valueOf(cell.getRichStringCellValue().getString()) : Boolean.FALSE);
        }
        return value;
    }

    private String readStringValue(Cell cell) {
        String value = null;
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 1: {
                value = cell.getRichStringCellValue().getString().trim();
                break;
            }
            case 0: {
                value = Double.toString(cell.getNumericCellValue()).trim();
                break;
            }
            case 3: {
                value = "";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                break;
            }
        }
        return value;
    }
}

