/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import net.sf.jxls.formula.Formula;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.parser.Expression;
import net.sf.jxls.transformer.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CellTransformer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Configuration configuration;

    public CellTransformer(Configuration configuration) {
        this.configuration = configuration != null ? configuration : new Configuration();
    }

    void transform(Cell cell) {
        try {
            if (cell.getPoiCell() != null && cell.getPoiCell().getCellType() == 1) {
                if (cell.getCollectionProperty() == null) {
                    if (cell.getFormula() == null) {
                        if (cell.getExpressions().size() == 0) {
                            if (cell.getMetaInfo() != null) {
                                cell.getPoiCell().setCellValue(cell.getPoiCell().getSheet().getWorkbook().getCreationHelper().createRichTextString(cell.getStringCellValue()));
                            }
                        } else if (cell.getExpressions().size() == 1) {
                            Object value = ((Expression)cell.getExpressions().get(0)).evaluate();
                            if (value == null) {
                                cell.getPoiCell().setCellValue(cell.getPoiCell().getSheet().getWorkbook().getCreationHelper().createRichTextString(""));
                                cell.getPoiCell().setCellType(3);
                            } else if (value instanceof Float) {
                                cell.getPoiCell().setCellValue(((Float)value).doubleValue());
                            } else if (value instanceof Double) {
                                cell.getPoiCell().setCellValue(((Double)value).doubleValue());
                            } else if (value instanceof BigDecimal) {
                                cell.getPoiCell().setCellValue(((BigDecimal)value).doubleValue());
                            } else if (value instanceof Date) {
                                cell.getPoiCell().setCellValue((Date)value);
                            } else if (value instanceof Calendar) {
                                cell.getPoiCell().setCellValue((Calendar)value);
                            } else if (value instanceof Byte) {
                                cell.getPoiCell().setCellValue((double)((Byte)value).intValue());
                            } else if (value instanceof Short) {
                                cell.getPoiCell().setCellValue((double)((Short)value).intValue());
                            } else if (value instanceof Integer) {
                                cell.getPoiCell().setCellValue((double)((Integer)value).intValue());
                            } else if (value instanceof Long) {
                                cell.getPoiCell().setCellValue((double)((Long)value).longValue());
                            } else if (value instanceof BigInteger) {
                                cell.getPoiCell().setCellValue(((BigInteger)value).doubleValue());
                            } else {
                                String fixedValue = value.toString();
                                if (fixedValue != null) {
                                    fixedValue = fixedValue.replaceAll("\r\n", "\n");
                                }
                                if (fixedValue.length() == 0) {
                                    cell.getPoiCell().setCellType(3);
                                } else {
                                    cell.getPoiCell().setCellValue(cell.getPoiCell().getSheet().getWorkbook().getCreationHelper().createRichTextString(fixedValue));
                                }
                            }
                        } else if (cell.getExpressions().size() > 1) {
                            String value = "";
                            for (int i = 0; i < cell.getExpressions().size(); ++i) {
                                Expression expr = (Expression)cell.getExpressions().get(i);
                                Object propValue = expr.evaluate();
                                if (propValue == null) continue;
                                value = value + propValue.toString();
                            }
                            this.setCellValue(cell, value);
                        }
                    } else {
                        CellTransformer.processFormulaCell(cell);
                    }
                } else {
                    String value = "";
                    for (int i = 0; i < cell.getExpressions().size(); ++i) {
                        Expression expr = (Expression)cell.getExpressions().get(i);
                        value = expr.getCollectionProperty() == null ? value + expr.evaluate() : value + this.configuration.getStartExpressionToken() + expr.getExpression() + this.configuration.getEndExpressionToken();
                    }
                    this.setCellValue(cell, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.debug((Object)"Can't parse expression");
        }
    }

    private void setCellValue(Cell cell, String value) {
        if (value == null || value.length() == 0) {
            cell.getPoiCell().setCellType(3);
        } else {
            cell.getPoiCell().setCellValue(cell.getPoiCell().getSheet().getWorkbook().getCreationHelper().createRichTextString(value));
        }
    }

    private static void processFormulaCell(Cell cell) {
        Formula formula = cell.getFormula();
        if (formula.isInline()) {
            if (cell.getCollectionName() != null) {
                cell.getPoiCell().setCellValue(cell.getPoiCell().getSheet().getWorkbook().getCreationHelper().createRichTextString(cell.getStringCellValue()));
            } else {
                String formulaString = formula.getInlineFormula(cell.getRow().getPoiRow().getRowNum() + 1);
                cell.getPoiCell().setCellFormula(formulaString);
            }
        }
    }
}

