/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.tag;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import net.sf.jxls.parser.Expression;
import net.sf.jxls.tag.BaseTag;
import net.sf.jxls.tag.Block;
import net.sf.jxls.tag.TagContext;
import net.sf.jxls.transformation.ResultTransformation;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.SheetTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class OutTag
extends BaseTag {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String TAG_NAME = "out";
    private Configuration configuration = new Configuration();
    private TagContext tagContext;
    private String expr;
    private String formula;
    private String label;

    public String getExpr() {
        return this.expr;
    }

    public void setExpr(String expr) {
        this.expr = expr;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return TAG_NAME;
    }

    public TagContext getTagContext() {
        return this.tagContext;
    }

    public void init(TagContext context) {
        this.tagContext = context;
    }

    public ResultTransformation process(SheetTransformer sheetTransformer) {
        ResultTransformation resultTransformation = new ResultTransformation(0);
        if (this.expr != null) {
            try {
                Cell cell;
                Row row;
                Sheet sheet;
                Block block = this.getTagContext().getTagBody();
                int rowNum = block.getStartRowNum();
                int cellNum = block.getStartCellNum();
                net.sf.jxls.transformer.Sheet jxlsSheet = this.getTagContext().getSheet();
                if (jxlsSheet != null && (sheet = jxlsSheet.getPoiSheet()) != null && (row = sheet.getRow(rowNum)) != null && (cell = row.getCell((int)((short)cellNum))) != null) {
                    Object value = new Expression(this.expr, this.tagContext.getBeans(), this.configuration).evaluate();
                    if (value == null) {
                        cell.setCellValue(sheet.getWorkbook().getCreationHelper().createRichTextString(""));
                    } else if (value instanceof Double) {
                        cell.setCellValue(((Double)value).doubleValue());
                    } else if (value instanceof BigDecimal) {
                        cell.setCellValue(((BigDecimal)value).doubleValue());
                    } else if (value instanceof Date) {
                        cell.setCellValue((Date)value);
                    } else if (value instanceof Calendar) {
                        cell.setCellValue((Calendar)value);
                    } else if (value instanceof Integer) {
                        cell.setCellValue((double)((Integer)value).intValue());
                    } else if (value instanceof Long) {
                        cell.setCellValue((double)((Long)value).longValue());
                    } else {
                        String fixedValue = value.toString();
                        if (fixedValue != null) {
                            fixedValue = fixedValue.replaceAll("\r\n", "\n");
                        }
                        cell.setCellValue(sheet.getWorkbook().getCreationHelper().createRichTextString(fixedValue));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.log.error((Object)"Cell expression evaluation has failed.", (Throwable)e);
            }
        }
        return resultTransformation;
    }
}

