/*
 * Decompiled with CFR 0.152.
 */
package play.modules.excel;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.net.URLCodec;
import play.PlayPlugin;
import play.exceptions.UnexpectedException;
import play.modules.excel.RenderExcel;
import play.mvc.Http;
import play.mvc.Scope;
import play.mvc.results.Result;
import play.templates.Template;
import play.vfs.VirtualFile;

public class Plugin
extends PlayPlugin {
    public static PlayPlugin templateLoader = null;
    private static final Pattern p_ = Pattern.compile(".*\\.(xls|xlsx)");
    private static final URLCodec encoder = new URLCodec();

    public Template loadTemplate(VirtualFile file) {
        if (!p_.matcher(file.getName()).matches()) {
            return null;
        }
        if (null == templateLoader) {
            return new ExcelTemplate(file);
        }
        return templateLoader.loadTemplate(file);
    }

    public void beforeActionInvocation(Method actionMethod) {
        Http.Request request = Http.Request.current();
        if (request.headers.get("accept") != null) {
            String accept = ((Http.Header)request.headers.get("accept")).value();
            if (accept.indexOf("text/csv") != -1) {
                request.format = "csv";
            }
            if (accept.matches(".*application\\/(excel|vnd\\.ms\\-excel|x\\-excel|x\\-msexcel).*")) {
                request.format = "xls";
            }
            if (accept.indexOf("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet") != -1) {
                request.format = "xlsx";
            }
        }
    }

    public void onActionInvocationResult(Result result) {
        Http.Request request = Http.Request.current();
        if (null != request.format && !request.format.matches("(csv|xls|xlsx)")) {
            return;
        }
        Http.Response response = Http.Response.current();
        Scope.RenderArgs renderArgs = Scope.RenderArgs.current();
        if (!response.headers.containsKey("Content-Disposition")) {
            String fileName = (String)renderArgs.get("__FILE_NAME__", String.class);
            if (fileName == null) {
                response.setHeader("Content-Disposition", "attachment; filename=export." + request.format);
            } else {
                try {
                    response.setHeader("Content-Disposition", "attachment; filename=" + encoder.encode(fileName, "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnexpectedException((Throwable)e);
                }
            }
            if (request.format.equals("xls")) {
                response.setContentTypeIfNotSet("application/vnd.ms-excel");
            } else if (request.format.equals("xlsx")) {
                response.setContentTypeIfNotSet("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            } else if (request.format.equals("csv")) {
                response.setContentTypeIfNotSet("text/csv");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExcelTemplate
    extends Template {
        private File file = null;
        private RenderExcel r_ = null;

        public ExcelTemplate(VirtualFile file) {
            this.name = file.relativePath();
            this.file = file.getRealFile();
        }

        public ExcelTemplate(RenderExcel render) {
            this.r_ = render;
        }

        public void compile() {
            if (!this.file.canRead()) {
                throw new UnexpectedException("template file not readable: " + this.name);
            }
        }

        protected String internalRender(Map<String, Object> args) {
            throw null == this.r_ ? new RenderExcel(this.name, args) : this.r_;
        }
    }
}

