/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.formula;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jxls.formula.FormulaPart;
import net.sf.jxls.formula.ListRange;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.transformer.Sheet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Formula {
    protected final Log log = LogFactory.getLog(this.getClass());
    private String formula;
    private Integer rowNum;
    private Integer cellNum;
    static final String inlineFormulaToken = "#";
    static final String formulaListRangeToken = "@";
    private Sheet sheet;
    private Set cellRefs = new HashSet();
    private List formulaParts = new ArrayList();
    private static final String regexFormulaPart = "[a-zA-Z]+[0-9]*\\([^@()]+\\)@[0-9]+";
    private static final Pattern regexFormulaPartPattern = Pattern.compile("[a-zA-Z]+[0-9]*\\([^@()]+\\)@[0-9]+");

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public Formula(String formula) {
        this.formula = formula;
        this.parseFormula();
    }

    public Formula() {
    }

    public Formula(Formula f) {
        this.formula = f.formula;
        this.sheet = f.getSheet();
        for (int i = 0; i < f.formulaParts.size(); ++i) {
            FormulaPart formulaPart = (FormulaPart)f.formulaParts.get(i);
            this.formulaParts.add(new FormulaPart(formulaPart));
        }
        this.updateCellRefs();
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public Integer getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(Integer rowNum) {
        this.rowNum = rowNum;
    }

    public Integer getCellNum() {
        return this.cellNum;
    }

    public void setCellNum(Integer cellNum) {
        this.cellNum = cellNum;
    }

    public Set getCellRefs() {
        return this.cellRefs;
    }

    public List getFormulaParts() {
        return this.formulaParts;
    }

    public boolean isInline() {
        return this.formula.indexOf(inlineFormulaToken) >= 0;
    }

    public String getInlineFormula(int n) {
        if (this.isInline()) {
            return this.formula.replaceAll(inlineFormulaToken, Integer.toString(n));
        }
        return this.formula;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getAppliedFormula(Map listRanges, Map namedCells) {
        String codedFormula = this.formula;
        String appliedFormula = "";
        String delimiter = formulaListRangeToken;
        int index = codedFormula.indexOf(delimiter);
        boolean isExpression = false;
        while (index >= 0) {
            String token = codedFormula.substring(0, index);
            if (isExpression) {
                if (listRanges.containsKey(token)) {
                    appliedFormula = appliedFormula + ((ListRange)listRanges.get(token)).toExcelCellRange();
                } else {
                    if (!namedCells.containsKey(token)) {
                        this.log.warn((Object)("can't find list range or named cell for " + token));
                        return null;
                    }
                    appliedFormula = appliedFormula + ((Cell)namedCells.get(token)).toCellName();
                }
            } else {
                appliedFormula = appliedFormula + token;
            }
            codedFormula = codedFormula.substring(index + 1);
            index = codedFormula.indexOf(delimiter);
            isExpression = !isExpression;
        }
        return appliedFormula + codedFormula;
    }

    public String getActualFormula() {
        String actualFormula = "";
        for (FormulaPart formulaPart : this.formulaParts) {
            actualFormula = actualFormula + formulaPart.getActualFormula();
        }
        return actualFormula;
    }

    public Set findRefCells() {
        HashSet refCells = new HashSet();
        for (FormulaPart formulaPart : this.formulaParts) {
            refCells.addAll(formulaPart.getRefCells());
        }
        return refCells;
    }

    public void parseFormula() {
        this.formulaParts.clear();
        Matcher formulaPartMatcher = regexFormulaPartPattern.matcher(this.formula);
        int end = 0;
        while (formulaPartMatcher.find()) {
            String formulaPartString = this.formula.substring(end, formulaPartMatcher.start());
            if (formulaPartString.length() > 0) {
                this.formulaParts.add(new FormulaPart(formulaPartString, this));
            }
            this.formulaParts.add(new FormulaPart(formulaPartMatcher.group(), this));
            end = formulaPartMatcher.end();
        }
        String endPart = this.formula.substring(end);
        if (endPart.length() > 0) {
            this.formulaParts.add(new FormulaPart(endPart, this));
        }
        this.updateCellRefs();
    }

    void updateCellRefs() {
        this.cellRefs = this.findRefCells();
    }

    public String toString() {
        return "Formula{formula='" + this.formula + "'" + ", rowNum=" + this.rowNum + ", cellNum=" + this.cellNum + "}";
    }

    public boolean containsListRanges() {
        return this.formula.matches("[^)]*@.*");
    }

    public void removeCellRefs(Set cellRefsToRemove) {
        for (int i = 0; i < this.formulaParts.size(); ++i) {
            FormulaPart formulaPart = (FormulaPart)this.formulaParts.get(i);
            formulaPart.removeCellRefs(cellRefsToRemove);
        }
        this.updateCellRefs();
    }

    public void updateReplacedRefCellsCollection() {
        for (FormulaPart formulaPart : this.formulaParts) {
            formulaPart.updateReplacedRefCellsCollection();
        }
    }
}

