/*
 * Decompiled with CFR 0.152.
 */
package play.modules.excel;

import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import play.PlayPlugin;
import play.exceptions.UnexpectedException;
import play.modules.excel.RenderExcel;
import play.templates.Template;
import play.vfs.VirtualFile;

public class Plugin
extends PlayPlugin {
    private static final Pattern p_ = Pattern.compile(".*\\.(xls|xlsx)");

    public Template loadTemplate(VirtualFile file) {
        if (p_.matcher(file.getName()).matches()) {
            return new ExcelTemplate(file);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExcelTemplate
    extends Template {
        private File file = null;

        private ExcelTemplate(VirtualFile file) {
            this.name = file.relativePath();
            this.file = file.getRealFile();
        }

        public void compile() {
            if (!this.file.canRead()) {
                throw new UnexpectedException("template file not readable: " + this.name);
            }
        }

        protected String internalRender(Map<String, Object> args) {
            throw new RenderExcel(this.name, args);
        }
    }
}

