/*
 * Decompiled with CFR 0.152.
 */
package play.modules.excel;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import net.sf.jxls.transformer.XLSTransformer;
import org.apache.poi.ss.usermodel.Workbook;
import play.Play;
import play.exceptions.UnexpectedException;
import play.mvc.Http;
import play.mvc.results.Result;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderExcel
extends Result {
    private static VirtualFile tmplRoot = null;
    String templateName = null;
    String fileName = null;
    Map<String, Object> beans = null;

    private static void initTmplRoot() {
        VirtualFile appRoot = VirtualFile.open((File)Play.applicationPath);
        String rootDef = "";
        if (Play.configuration.containsKey("excel.template.root")) {
            rootDef = (String)Play.configuration.get("excel.template.root");
        }
        tmplRoot = appRoot.child(rootDef);
    }

    public RenderExcel(String templateName, Map<String, Object> beans) {
        this(templateName, beans, null);
    }

    public RenderExcel(String templateName, Map<String, Object> beans, String fileName) {
        this.templateName = templateName;
        this.beans = beans;
        this.fileName = fileName == null ? RenderExcel.fileName_(templateName) : fileName;
    }

    private static String fileName_(String path) {
        int i = path.lastIndexOf("/");
        if (-1 == i) {
            return path;
        }
        return path.substring(++i);
    }

    public static void main(String[] args) {
        System.out.println(RenderExcel.fileName_("abc.xls"));
        System.out.println(RenderExcel.fileName_("/xyz/abc.xls"));
        System.out.println(RenderExcel.fileName_("app/xyz/abc.xls"));
    }

    public void apply(Http.Request request, Http.Response response) {
        try {
            if (null == tmplRoot) {
                RenderExcel.initTmplRoot();
            }
            InputStream is = tmplRoot.child(this.templateName).inputstream();
            Workbook workbook = new XLSTransformer().transformXLS(is, this.beans);
            workbook.write((OutputStream)response.out);
            is.close();
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }
}

