/*
 * Decompiled with CFR 0.152.
 */
package play.template2;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import play.template2.GTContentRenderer;
import play.template2.GTFastTagResolver;
import play.template2.GTJavaBase;

public abstract class GTFastTag
implements GTFastTagResolver {
    protected GTFastTag() {
    }

    @Override
    public String resolveFastTag(String tagName) {
        TagNamespace tagNamespace = this.getClass().getAnnotation(TagNamespace.class);
        if (tagNamespace != null) {
            String namespace = tagNamespace.value();
            if (!tagName.startsWith(namespace + ".")) {
                return null;
            }
            tagName = tagName.substring(namespace.length() + 1);
        }
        try {
            Method m = this.getClass().getMethod("tag_" + tagName, GTJavaBase.class, Map.class, GTContentRenderer.class);
            if (!Modifier.isStatic(m.getModifiers())) {
                throw new RuntimeException("A fast-tag method must be static: " + m);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return this.getClass().getName() + ".tag_" + tagName;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface TagNamespace {
        public String value() default "";
    }
}

