/*
 * Decompiled with CFR 0.152.
 */
package play.template2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import play.template2.GTJavaBase;
import play.template2.GTTemplateInstanceFactory;
import play.template2.compile.GTCompiler;
import play.template2.compile.GTJavaCompileToClass;
import play.template2.exceptions.GTException;

public class GTTemplateInstanceFactoryLive
extends GTTemplateInstanceFactory {
    private final Class<? extends GTJavaBase> templateClass;
    private final GTCompiler.CompiledTemplate compiledTemplate;
    private final CL cl;
    public static ProtectionDomain protectionDomain;

    public GTTemplateInstanceFactoryLive(ClassLoader parentClassLoader, GTCompiler.CompiledTemplate compiledTemplate) {
        this.compiledTemplate = compiledTemplate;
        this.cl = new CL(parentClassLoader, compiledTemplate.compiledJavaClasses);
        try {
            this.templateClass = this.cl.loadClass(compiledTemplate.templateClassName);
        }
        catch (Exception e) {
            throw new GTException("Error creating template class instance", e);
        }
    }

    @Override
    public Class<? extends GTJavaBase> getTemplateClass() {
        return this.templateClass;
    }

    public static class CL
    extends ClassLoader {
        private final Set<String> classNames;
        private final Map<String, byte[]> resource2bytes;
        private final ClassLoader parent;

        public CL(ClassLoader parent, GTJavaCompileToClass.CompiledClass[] compiledClasses) {
            this.parent = parent;
            this.classNames = new HashSet<String>(compiledClasses.length);
            this.resource2bytes = new HashMap<String, byte[]>(compiledClasses.length);
            for (GTJavaCompileToClass.CompiledClass cp : compiledClasses) {
                this.classNames.add(cp.classname);
                this.defineClass(cp.classname, cp.bytes, 0, cp.bytes.length, protectionDomain);
                String resourceName = cp.classname.replace(".", "/") + ".class";
                this.resource2bytes.put(resourceName, cp.bytes);
            }
        }

        @Override
        public InputStream getResourceAsStream(String s) {
            if (this.resource2bytes.containsKey(s)) {
                return new ByteArrayInputStream(this.resource2bytes.get(s));
            }
            return this.parent.getResourceAsStream(s);
        }

        @Override
        public Class<?> loadClass(String s) throws ClassNotFoundException {
            if (!this.classNames.contains(s)) {
                return this.parent.loadClass(s);
            }
            return super.loadClass(s);
        }

        @Override
        public URL getResource(String s) {
            if (!this.classNames.contains(s)) {
                return this.parent.getResource(s);
            }
            return super.getResource(s);
        }

        @Override
        public Enumeration<URL> getResources(String s) throws IOException {
            if (!this.classNames.contains(s)) {
                return this.parent.getResources(s);
            }
            return super.getResources(s);
        }

        @Override
        public void setDefaultAssertionStatus(boolean b) {
            super.setDefaultAssertionStatus(b);
        }

        @Override
        public void setPackageAssertionStatus(String s, boolean b) {
            super.setPackageAssertionStatus(s, b);
        }

        @Override
        public void setClassAssertionStatus(String s, boolean b) {
            super.setClassAssertionStatus(s, b);
        }

        @Override
        public void clearAssertionStatus() {
            super.clearAssertionStatus();
        }
    }
}

