/*
 * Decompiled with CFR 0.152.
 */
package play.template2;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import play.template2.GTExceptionFixer;
import play.template2.GTFileResolver;
import play.template2.GTJavaBase;
import play.template2.GTLineMapper;
import play.template2.GTTemplateInstanceFactory;
import play.template2.GTTemplateInstanceFactoryLive;
import play.template2.GTTemplateInstanceFactoryRegularClass;
import play.template2.GTTemplateLocation;
import play.template2.GTTemplateLocationReal;
import play.template2.IO;
import play.template2.compile.GTCompiler;
import play.template2.compile.GTJavaCompileToClass;
import play.template2.compile.GTPreCompiler;
import play.template2.compile.GTPreCompilerFactory;
import play.template2.exceptions.GTCompilationException;
import play.template2.exceptions.GTCompilationExceptionWithSourceInfo;
import play.template2.exceptions.GTException;
import play.template2.exceptions.GTRuntimeException;
import play.template2.exceptions.GTTemplateNotFound;

public class GTTemplateRepo {
    public final ClassLoader parentClassLoader;
    public final boolean checkForChanges;
    public final GTPreCompilerFactory preCompilerFactory;
    public final boolean preCompiledMode;
    public final File folderToDumpClassesIn;
    private Map<String, TemplateInfo> loadedTemplates = new ConcurrentHashMap<String, TemplateInfo>();
    protected Map<String, TemplateInfo> classname2TemplateInfo = new ConcurrentHashMap<String, TemplateInfo>();

    public GTTemplateRepo(ClassLoader parentClassLoader, boolean checkForChanges, GTPreCompilerFactory preCompilerFactory, boolean preCompiledMode, File folderToDumpClassesIn) {
        this.parentClassLoader = parentClassLoader;
        if (parentClassLoader == null) {
            throw new GTException("parentClassLoader cannot be null");
        }
        this.checkForChanges = checkForChanges;
        this.preCompilerFactory = preCompilerFactory;
        if (preCompilerFactory == null) {
            throw new GTException("preCompilerFactory cannot be null");
        }
        this.preCompiledMode = preCompiledMode;
        this.folderToDumpClassesIn = folderToDumpClassesIn;
    }

    public boolean templateExists(GTTemplateLocation templateLocation) {
        try {
            this.getTemplateInstance(templateLocation, false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void removeTemplate(String templatePath) {
        TemplateInfo ti = this.loadedTemplates.remove(templatePath);
        if (ti != null) {
            this.classname2TemplateInfo.remove(ti.getTemplateClass().getName());
        }
    }

    private void addTemplate(String templatePath, TemplateInfo ti) {
        this.loadedTemplates.put(templatePath, ti);
        this.classname2TemplateInfo.put(ti.getTemplateClass().getName(), ti);
    }

    public GTJavaBase getTemplateInstance(GTTemplateLocation templateLocation) throws GTTemplateNotFound {
        return this.getTemplateInstance(templateLocation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GTJavaBase getTemplateInstance(GTTemplateLocation templateLocation, boolean doCompile) throws GTTemplateNotFound {
        TemplateInfo ti = this.loadedTemplates.get(templateLocation.relativePath);
        if (ti == null || this.checkForChanges) {
            Map<String, TemplateInfo> map = this.loadedTemplates;
            synchronized (map) {
                ti = this.loadedTemplates.get(templateLocation.relativePath);
                if (ti == null) {
                    ti = this.lookForPreCompiledOrCached(templateLocation);
                }
                if (ti != null && ti.isModified()) {
                    this.removeTemplate(templateLocation.relativePath);
                    ti = null;
                }
                if (ti == null) {
                    if (templateLocation instanceof GTTemplateLocationReal) {
                        try {
                            ((GTTemplateLocationReal)templateLocation).realFileURL.openStream().close();
                        }
                        catch (Exception e) {
                            throw new GTTemplateNotFound(templateLocation.relativePath);
                        }
                    }
                    if (!doCompile) {
                        return null;
                    }
                    ti = this.compileTemplate(templateLocation);
                }
                if (ti != null) {
                    this.addTemplate(templateLocation.relativePath, ti);
                }
            }
        }
        if (ti == null) {
            throw new GTTemplateNotFound(templateLocation.relativePath);
        }
        GTJavaBase templateInstance = ti.templateInstanceFactory.create(this);
        return templateInstance;
    }

    private TemplateInfo lookForPreCompiledOrCached(GTTemplateLocation templateLocation) {
        String templateClassName = GTPreCompiler.generatedPackageName + "." + GTPreCompiler.generateTemplateClassname(templateLocation.relativePath);
        if (this.preCompiledMode) {
            try {
                Class<?> templateClass = this.parentClassLoader.loadClass(templateClassName);
                return new TemplateInfo(templateLocation, new GTTemplateInstanceFactoryRegularClass(templateClass));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else if (this.folderToDumpClassesIn != null) {
            return this.loadTemplateFromDisk(templateLocation, templateClassName);
        }
        return null;
    }

    private TemplateInfo loadTemplateFromDisk(GTTemplateLocation templateLocation, String templateClassName) {
        String classFilenameWithPath = templateClassName.replace('.', '/') + ".class";
        File file = new File(this.folderToDumpClassesIn, classFilenameWithPath);
        if (!file.exists()) {
            return null;
        }
        GTTemplateLocationReal templateLocationReal = GTFileResolver.impl.getTemplateLocationFromRelativePath(templateLocation.relativePath);
        if (templateLocationReal == null) {
            file.delete();
            return null;
        }
        File realFile = IO.getFileFromURL(templateLocationReal.realFileURL);
        if (realFile == null) {
            return null;
        }
        if (realFile.lastModified() != file.lastModified()) {
            file.delete();
            return null;
        }
        File folder = file.getParentFile();
        final String simpleFilename = file.getName().substring(0, file.getName().length() - 6);
        File[] allClassFiles = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.startsWith(simpleFilename);
            }
        });
        GTJavaCompileToClass.CompiledClass[] compiledClasses = new GTJavaCompileToClass.CompiledClass[allClassFiles.length];
        int i = 0;
        for (File classFile : allClassFiles) {
            byte[] bytes = IO.readContent(classFile);
            String className = GTPreCompiler.generatedPackageName + "." + classFile.getName().substring(0, classFile.getName().length() - 6);
            compiledClasses[i++] = new GTJavaCompileToClass.CompiledClass(className, bytes);
        }
        GTCompiler.CompiledTemplate compiledTemplate = new GTCompiler.CompiledTemplate(templateClassName, compiledClasses);
        return new TemplateInfo(templateLocationReal, new GTTemplateInstanceFactoryLive(this.parentClassLoader, compiledTemplate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemplate(GTTemplateLocation templateLocation) {
        Map<String, TemplateInfo> map = this.loadedTemplates;
        synchronized (map) {
            this.removeTemplate(templateLocation.relativePath);
        }
    }

    public TemplateInfo compileTemplate(GTTemplateLocation templateLocation) throws GTException {
        TemplateInfo ti;
        try {
            GTCompiler.CompiledTemplate compiledTemplate = new GTCompiler(this.parentClassLoader, this, this.preCompilerFactory, true).compile(templateLocation);
            if (this.folderToDumpClassesIn != null && templateLocation instanceof GTTemplateLocationReal) {
                IO.FileInfo fileInfo = IO.getFileInfo(((GTTemplateLocationReal)templateLocation).realFileURL);
                for (GTJavaCompileToClass.CompiledClass compiledClass : compiledTemplate.compiledJavaClasses) {
                    String filename = compiledClass.classname.replace('.', '/') + ".class";
                    File file = new File(this.folderToDumpClassesIn, filename);
                    file.getParentFile().mkdirs();
                    IO.write(compiledClass.bytes, file);
                    file.setLastModified(fileInfo.lastModified);
                }
            }
            GTTemplateInstanceFactoryLive templateInstanceFactory = new GTTemplateInstanceFactoryLive(this.parentClassLoader, compiledTemplate);
            ti = new TemplateInfo(templateLocation, templateInstanceFactory);
        }
        catch (GTTemplateNotFound e) {
            throw e;
        }
        catch (GTCompilationExceptionWithSourceInfo e) {
            throw e;
        }
        catch (Exception e) {
            throw new GTCompilationException(e);
        }
        return ti;
    }

    public GTRuntimeException fixException(Throwable e) {
        return new GTExceptionFixer(this).fixException(e);
    }

    public static class TemplateInfo {
        public final GTTemplateLocation templateLocation;
        public final long fileSize;
        public final long fileDate;
        public final GTTemplateInstanceFactory templateInstanceFactory;

        private TemplateInfo(GTTemplateLocation templateLocation, GTTemplateInstanceFactory templateInstanceFactory) {
            this.templateLocation = templateLocation;
            if (templateLocation instanceof GTTemplateLocationReal) {
                GTTemplateLocationReal real = (GTTemplateLocationReal)templateLocation;
                IO.FileInfo fileInfo = IO.getFileInfo(real.realFileURL);
                this.fileSize = fileInfo.size;
                this.fileDate = fileInfo.lastModified;
            } else {
                this.fileSize = 0L;
                this.fileDate = 0L;
            }
            this.templateInstanceFactory = templateInstanceFactory;
        }

        public boolean isModified() {
            if (!(this.templateLocation instanceof GTTemplateLocationReal)) {
                return false;
            }
            File freshFile = IO.getFileFromURL(((GTTemplateLocationReal)this.templateLocation).realFileURL);
            if (freshFile == null) {
                return false;
            }
            if (!freshFile.exists() || !freshFile.isFile()) {
                return true;
            }
            if (this.fileSize != freshFile.length()) {
                return true;
            }
            return this.fileDate != freshFile.lastModified();
        }

        public Class<? extends GTJavaBase> getTemplateClass() {
            return this.templateInstanceFactory.getTemplateClass();
        }

        public GTLineMapper getGroovyLineMapper() {
            try {
                return (GTLineMapper)this.getTemplateClass().getDeclaredMethod("getGroovyLineMapper", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public GTLineMapper getJavaLineMapper() {
            try {
                return (GTLineMapper)this.getTemplateClass().getDeclaredMethod("getJavaLineMapper", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

